/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.core.builder;

import group.flyfish.rest.utils.DataUtils;
import group.flyfish.rest.utils.JacksonUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MapParamBuilder {
    private static final String PAGE_KEY = "pageUtil";
    private static final String EMPTY_PATTERN = "{}";
    private Map<String, Object> params = new HashMap<String, Object>();

    private MapParamBuilder() {
    }

    public static MapParamBuilder builder() {
        return new MapParamBuilder();
    }

    public static MapParamBuilder of(Map<String, Object> initialParams) {
        MapParamBuilder builder = new MapParamBuilder();
        builder.withAll(initialParams);
        return builder;
    }

    public static MapParamBuilder empty() {
        MapParamBuilder builder = new MapParamBuilder();
        builder.params = Collections.emptyMap();
        return builder;
    }

    public static <T> T any(Map<String, Object> map, String key) {
        Object value = map.get(key);
        return (T)value;
    }

    public MapParamBuilder with(String key, Object value) {
        if (DataUtils.isNotBlank(key) && value != null) {
            this.params.put(key, value);
        }
        return this;
    }

    public boolean has(String key) {
        return this.params.containsKey(key);
    }

    public MapParamBuilder with(String key, Collection<?> value, Collection<?> defaultValue) {
        if (DataUtils.isNotBlank(key) && DataUtils.isNotEmpty(value)) {
            this.params.put(key, value);
        } else {
            this.params.put(key, defaultValue);
        }
        return this;
    }

    public MapParamBuilder with(String key, String value) {
        if (DataUtils.isNotBlank(key) && DataUtils.isNotBlank(value)) {
            this.params.put(key, value);
        }
        return this;
    }

    public MapParamBuilder with(String key, Integer value) {
        if (DataUtils.isNotBlank(key) && value != null) {
            this.params.put(key, value);
        }
        return this;
    }

    public MapParamBuilder exchange(String oldKey, String newKey) {
        if (this.params.containsKey(oldKey) && this.params.containsKey(newKey)) {
            Object oldValue = this.params.get(oldKey);
            Object newValue = this.params.get(newKey);
            this.params.put(oldKey, newValue);
            this.params.put(newKey, oldValue);
        }
        return this;
    }

    public MapParamBuilder replace(String oldKey, String newKey) {
        Object value = this.params.get(oldKey);
        if (null != value) {
            this.params.remove(oldKey);
            this.params.put(newKey, value);
        }
        return this;
    }

    public MapParamBuilder clear(String key) {
        this.params.remove(key);
        return this;
    }

    public MapParamBuilder with(String key, Long value) {
        if (DataUtils.isNotBlank(key) && value != null) {
            this.params.put(key, value);
        }
        return this;
    }

    public MapParamBuilder withAll(Map<String, ?> params) {
        if (DataUtils.isNotEmpty(params)) {
            params.forEach(this::with);
        }
        return this;
    }

    public MapParamBuilder withPage(Map<String, Object> params) {
        if (params.containsKey(PAGE_KEY)) {
            this.params.put("page", params.get(PAGE_KEY));
        }
        return this;
    }

    public <T> T take(String key) {
        return (T)this.params.get(key);
    }

    public boolean isEmpty() {
        return DataUtils.isEmpty(this.params);
    }

    public Map<String, Object> build() {
        return this.params;
    }

    public String toString() {
        if (DataUtils.isEmpty(this.params)) {
            return EMPTY_PATTERN;
        }
        return JacksonUtil.toJson(this.params).orElse(null);
    }
}

