/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.core.builder;

import group.flyfish.rest.utils.JacksonUtil;
import java.util.HashMap;
import java.util.Map;

public final class TypedMapBuilder<K, V> {
    private final Map<K, V> params = new HashMap();

    private TypedMapBuilder() {
    }

    public static <K, V> TypedMapBuilder<K, V> builder() {
        return new TypedMapBuilder<K, V>();
    }

    public static TypedMapBuilder<String, String> stringMapBuilder() {
        return new TypedMapBuilder<String, String>();
    }

    public static TypedMapBuilder<String, Object> stringObjectBuilder() {
        return new TypedMapBuilder<String, Object>();
    }

    public TypedMapBuilder<K, V> with(K key, V value) {
        if (key != null && value != null) {
            this.params.put(key, value);
        }
        return this;
    }

    public TypedMapBuilder<K, V> withAll(Map<K, V> values) {
        values.forEach(this::with);
        return this;
    }

    public Map<K, V> build() {
        return this.params;
    }

    public String toString() {
        return JacksonUtil.toJson(this).orElse(null);
    }
}

