/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.core.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import group.flyfish.rest.constants.RestConstants;
import group.flyfish.rest.core.client.RestClient;
import group.flyfish.rest.core.client.RestErrorHandler;
import group.flyfish.rest.core.exception.RestClientException;
import group.flyfish.rest.core.factory.HttpClientFactoryBean;
import group.flyfish.rest.core.factory.HttpClientProvider;
import group.flyfish.rest.enums.ResponseType;
import group.flyfish.rest.utils.JacksonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;

final class DefaultRestClient
extends RestErrorHandler
implements RestClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultRestClient.class);
    private final HttpRequestBase request;
    private boolean async = false;
    private Consumer<HttpEntity> consumer;
    private ExecutorService executorService;
    private ResponseType responseType = ResponseType.NORMAL;
    private Class<?> resultClass;
    private TypeReference<?> typeReference;
    private JavaType resultType;
    private HttpClientProvider clientProvider;

    DefaultRestClient(HttpRequestBase request, HttpClientProvider provider) {
        this.request = request;
        this.clientProvider = provider;
    }

    DefaultRestClient(HttpRequestBase request) {
        this.request = request;
        this.clientProvider = HttpClientFactoryBean::createSSLClient;
    }

    @Override
    public RestClient onError(Consumer<RestClientException> errorConsumer) {
        this.errorConsumer = errorConsumer;
        return this;
    }

    @Override
    public RestClient responseType(ResponseType responseType) {
        this.responseType = responseType;
        return this;
    }

    @Override
    public void setClient(HttpClientProvider provider) {
        this.clientProvider = provider;
    }

    @Override
    public RestClient async() {
        this.async = true;
        this.executorService = RestConstants.DEFAULT_EXECUTOR;
        return this;
    }

    @Override
    public RestClient async(ExecutorService executorService) {
        this.async = true;
        this.executorService = executorService;
        return this;
    }

    @Override
    public void execute(Consumer<HttpEntity> consumer) {
        this.consumer = consumer;
        if (this.async) {
            if (this.executorService == null) {
                this.handleError("\u7ebf\u7a0b\u6c60\u672a\u6307\u5b9a\u6216\u4e3a\u7a7a\uff01");
            }
            this.executorService.submit(this::executeSafety);
        } else {
            this.executeSafety();
        }
    }

    @Override
    public void executeSilent() {
        this.executeSafety();
    }

    @Override
    public Map<String, Object> executeForMap() throws IOException {
        this.responseType = ResponseType.JSON;
        return (Map)this.innerExecute();
    }

    @Override
    public String executeForString() throws IOException {
        this.responseType = ResponseType.TEXT;
        return (String)this.innerExecute();
    }

    private void executeSafety() {
        try {
            this.execute();
        }
        catch (IOException e) {
            this.handleError("\u53d1\u8d77\u8bf7\u6c42\u65f6\u51fa\u73b0\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    @Nullable
    public <T> T execute(Class<T> clazz) {
        this.responseType = this.resolveType(clazz);
        this.resultClass = clazz;
        try {
            return this.innerExecute();
        }
        catch (IOException e) {
            log.error("\u8bf7\u6c42\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }

    @Override
    @Nullable
    public <T> T execute(JavaType type) {
        this.responseType = this.resolveType(type.getRawClass());
        this.resultType = type;
        try {
            return this.innerExecute();
        }
        catch (IOException e) {
            log.error("\u8bf7\u6c42\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }

    @Override
    @Nullable
    public <T> T execute(TypeReference<T> typeReference) {
        this.responseType = ResponseType.OBJECT;
        this.typeReference = typeReference;
        try {
            return this.innerExecute();
        }
        catch (IOException e) {
            log.error("\u8bf7\u6c42\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }

    @Override
    public <T> T execute() throws IOException {
        return this.innerExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T innerExecute() throws IOException {
        block21: {
            log.info("\u3010Rest Invoke\u3011{} {}", (Object)this.request.getMethod(), (Object)this.request.getURI());
            try {
                T t;
                try (CloseableHttpResponse response = this.clientProvider.getClient().execute((HttpUriRequest)this.request);){
                    StatusLine statusLine = response.getStatusLine();
                    HttpEntity entity = response.getEntity();
                    if (HttpStatus.valueOf((int)statusLine.getStatusCode()).isError()) {
                        this.handleError(this.request.getURI(), statusLine.getStatusCode(), this.handleEntity(entity));
                        break block21;
                    }
                    t = this.handleEntity(entity);
                }
                return t;
            }
            catch (UnknownHostException e) {
                this.handleError("\u672a\u77e5\u7684\u8bf7\u6c42\u5730\u5740\uff01", e);
            }
            finally {
                this.request.releaseConnection();
            }
        }
        return null;
    }

    private ResponseType resolveType(Class<?> clazz) {
        return RestConstants.RESPONSE_TYPE_MAP.getOrDefault(clazz.getName(), ResponseType.OBJECT);
    }

    private <T> T handleEntity(HttpEntity entity) throws IOException {
        if (null == entity) {
            return null;
        }
        if (this.consumer != null) {
            this.consumer.accept(entity);
            return null;
        }
        return this.resolveResponse(entity);
    }

    private <T> T resolveResponse(HttpEntity entity) throws IOException {
        switch (this.responseType) {
            case TEXT: {
                return (T)EntityUtils.toString((HttpEntity)entity);
            }
            case JSON: {
                return (T)JacksonUtil.json2Map(EntityUtils.toString((HttpEntity)entity));
            }
            case BINARY: {
                try (InputStream in = entity.getContent();){
                    byte[] byArray = StreamUtils.copyToByteArray((InputStream)in);
                    return (T)byArray;
                }
            }
            case OBJECT: {
                if (null != this.resultClass) {
                    return (T)JacksonUtil.fromJson(EntityUtils.toString((HttpEntity)entity), this.resultClass);
                }
                if (null != this.typeReference) {
                    return (T)JacksonUtil.fromJson(EntityUtils.toString((HttpEntity)entity), this.typeReference);
                }
                if (null == this.resultType) break;
                return JacksonUtil.fromJson(EntityUtils.toString((HttpEntity)entity), this.resultType);
            }
        }
        return (T)entity;
    }
}

