/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.core.client;

import group.flyfish.rest.constants.RestConstants;
import group.flyfish.rest.core.client.DefaultRestClient;
import group.flyfish.rest.core.client.RestClient;
import group.flyfish.rest.entity.Multipart;
import group.flyfish.rest.enums.HttpMethod;
import group.flyfish.rest.utils.DataUtils;
import group.flyfish.rest.utils.JacksonUtil;
import group.flyfish.rest.utils.RequestContext;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;

public class RestClientBuilder {
    private String url;
    private HttpMethod method = HttpMethod.GET;
    private Map<String, Object> params;
    private String body;
    private Map<String, String> headers;
    private List<Multipart> multipartList;
    private boolean multipart;
    private boolean credential;
    private String charset;
    private RequestConfig config;

    public String getUrl() {
        return this.url;
    }

    public RestClientBuilder url(String url) {
        this.url = url;
        return this;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public RestClientBuilder method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public RestClientBuilder get() {
        this.method = HttpMethod.GET;
        return this;
    }

    public RestClientBuilder post() {
        this.method = HttpMethod.POST;
        return this;
    }

    public RestClientBuilder multipart() {
        this.multipart = true;
        return this;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public Map<String, Object> getParams() {
        if (null == this.params) {
            this.params = new HashMap<String, Object>();
        }
        return this.params;
    }

    public RestClientBuilder queryParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public RestClientBuilder addParam(String key, Object value) {
        if (null == this.params) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(key, value);
        return this;
    }

    public RestClientBuilder charset(String charset) {
        this.charset = charset;
        return this;
    }

    public RestClientBuilder withCredential() {
        this.credential = true;
        return this;
    }

    public RestClientBuilder config(RequestConfig config) {
        this.config = config;
        return this;
    }

    public Charset getCharset() {
        return DataUtils.isBlank(this.charset) ? Charset.defaultCharset() : Charset.forName(this.charset);
    }

    public RestClientBuilder addMultipartBody(String name, String filename, Object data) {
        return this.addMultipartBody(new Multipart(name, filename, data));
    }

    public RestClientBuilder addMultipartBody(Multipart part) {
        if (null == this.multipartList) {
            this.multipartList = new ArrayList<Multipart>();
        }
        this.multipartList.add(part);
        return this;
    }

    public List<Multipart> getMultipartList() {
        if (null == this.multipartList) {
            this.multipartList = new ArrayList<Multipart>();
        }
        return this.multipartList;
    }

    public String getBody() {
        return this.body;
    }

    public RestClientBuilder body(String body) {
        this.body = body;
        return this;
    }

    public RestClientBuilder body(Object body) {
        this.body = JacksonUtil.toJson(body).orElse(null);
        return this;
    }

    public Map<String, String> getHeaders() {
        if (null == this.headers) {
            this.headers = new HashMap<String, String>();
        }
        return this.headers;
    }

    public RestClientBuilder headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public RestClientBuilder addHeader(String key, String value) {
        if (null == this.headers) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    private HttpRequestBase buildRequest() {
        HttpRequestBase request = RestConstants.RESOLVER_MAP.getOrDefault(this.method, RestConstants.RESOLVER_MAP.get(HttpMethod.GET)).resolve(this);
        if (this.credential) {
            RequestContext.getCredential().ifPresent(value -> this.addHeader("Authorization", (String)value));
        }
        this.getHeaders().forEach((arg_0, arg_1) -> ((HttpRequestBase)request).addHeader(arg_0, arg_1));
        request.setConfig(null == this.config ? RestConstants.REQUEST_CONFIG : this.config);
        return request;
    }

    public RestClient build() {
        HttpRequestBase request = this.buildRequest();
        return new DefaultRestClient(request);
    }
}

