/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.core.client;

import group.flyfish.rest.core.exception.RestClientException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(RestErrorHandler.class);
    protected Consumer<RestClientException> errorConsumer;

    private void handleError(RestClientException e) {
        log.error(e.getMessage());
        if (null == this.errorConsumer) {
            throw e;
        }
        this.errorConsumer.accept(e);
    }

    protected void handleError(String message) {
        this.handleError(new RestClientException(message));
    }

    protected void handleError(String message, Exception cause) {
        this.handleError(new RestClientException(message + cause.getMessage(), cause));
    }

    protected void handleError(URI uri, int status, Object data) {
        String message = MessageFormat.format("\u8bf7\u6c42\u63a5\u53e3{0}\u72b6\u6001\u5f02\u5e38\uff01\u4ee3\u7801\uff1a{1}", uri, status);
        this.handleError(new RestClientException(message, status, data));
    }
}

