/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.core.factory;

import group.flyfish.rest.configuration.RestClientProperties;
import group.flyfish.rest.configuration.configure.PropertiesConfigurable;
import group.flyfish.rest.utils.DataUtils;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public final class HttpClientFactoryBean
implements FactoryBean<CloseableHttpClient>,
PropertiesConfigurable {
    private static final Logger log = LoggerFactory.getLogger(HttpClientFactoryBean.class);
    private final ReentrantLock lock = new ReentrantLock();
    private volatile CloseableHttpClient client;
    private RestClientProperties properties;

    private CloseableHttpClient getClient() {
        return DataUtils.isTrue(this.properties.getAlwaysTrust()) ? HttpClientFactoryBean.createSSLClient() : HttpClients.createDefault();
    }

    public static CloseableHttpClient createSSLClient() {
        try {
            SSLContext context = SSLContextBuilder.create().loadTrustMaterial(null, (arg0, arg1) -> true).build();
            SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(context);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)factory).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CloseableHttpClient getObject() throws Exception {
        if (this.client == null) {
            this.lock.lock();
            try {
                if (this.client == null) {
                    this.client = this.getClient();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.client;
    }

    public Class<?> getObjectType() {
        return CloseableHttpClient.class;
    }

    @Override
    public void configure(RestClientProperties properties) {
        this.properties = properties;
    }
}

