/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.core.resolver.support;

import group.flyfish.rest.constants.RestConstants;
import group.flyfish.rest.core.client.RestClientBuilder;
import group.flyfish.rest.core.resolver.support.AbstractParamResolver;
import group.flyfish.rest.utils.DataUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;

public abstract class AbstractBodyResolver
extends AbstractParamResolver {
    protected HttpEntity buildEntity(RestClientBuilder builder) {
        return builder.isMultipart() ? this.buildMultipart(this.resolveParams(builder)) : (DataUtils.isNotBlank(builder.getBody()) ? this.buildJson(this.resolveParams(builder)) : this.buildFormData(builder));
    }

    private HttpEntity buildMultipart(RestClientBuilder clientBuilder) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.setCharset(clientBuilder.getCharset());
        clientBuilder.getMultipartList().forEach(multipart -> {
            Object data = multipart.getData();
            String name = multipart.getName();
            String filename = multipart.getFilename();
            if (data instanceof byte[]) {
                builder.addBinaryBody(name, (byte[])data, this.resolveType(filename), filename);
            } else if (data instanceof File) {
                builder.addBinaryBody(name, (File)data, this.resolveType(filename), filename);
            } else if (data instanceof InputStream) {
                builder.addBinaryBody(name, (InputStream)data, this.resolveType(filename), filename);
            } else {
                builder.addTextBody(name, String.valueOf(data));
            }
        });
        return builder.build();
    }

    private HttpEntity buildJson(RestClientBuilder clientBuilder) {
        clientBuilder.addHeader("Content-Type", "application/json;charset=UTF-8");
        Charset charset = clientBuilder.getCharset();
        StringEntity entity = new StringEntity(clientBuilder.getBody(), charset);
        entity.setContentEncoding(charset.toString());
        entity.setContentType("application/json");
        return entity;
    }

    private HttpEntity buildFormData(RestClientBuilder clientBuilder) {
        Map<String, Object> params = clientBuilder.getParams();
        List list = params.keySet().stream().filter(key -> null != params.get(key)).map(key -> new BasicNameValuePair(key, String.valueOf(params.get(key)))).collect(Collectors.toList());
        if (DataUtils.isNotEmpty(list)) {
            return new UrlEncodedFormEntity(list, clientBuilder.getCharset());
        }
        return null;
    }

    private ContentType resolveType(String filename) {
        return ContentType.create((String)RestConstants.MIME_MAP.getOrDefault(DataUtils.getExtension(filename), ContentType.APPLICATION_OCTET_STREAM.getMimeType()));
    }
}

