/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.core.resolver.support;

import group.flyfish.rest.core.client.RestClientBuilder;
import group.flyfish.rest.utils.DataUtils;
import java.util.stream.Collectors;

public abstract class AbstractParamResolver {
    protected RestClientBuilder resolveParams(RestClientBuilder builder) {
        if (DataUtils.isNotEmpty(builder.getParams())) {
            String start = builder.getUrl().contains("?") ? "&" : "?";
            String params = builder.getParams().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + this.parseValue(entry.getValue())).collect(Collectors.joining("&"));
            builder.url(builder.getUrl() + start + params);
        }
        return builder;
    }

    private String parseValue(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Iterable) {
            Iterable mapped = (Iterable)DataUtils.cast(value);
            return String.join((CharSequence)",", mapped);
        }
        if (null != value) {
            return String.valueOf(value);
        }
        return "";
    }
}

