/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.registry;

import group.flyfish.rest.annotation.EnableRestApiProxy;
import group.flyfish.rest.annotation.RestService;
import group.flyfish.rest.core.factory.HttpClientProvider;
import group.flyfish.rest.registry.proxy.RestProxyInvoker;
import group.flyfish.rest.registry.proxy.support.RestArgumentResolverComposite;
import group.flyfish.rest.utils.DataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class RestApiRegistry
implements BeanDefinitionRegistryPostProcessor,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(RestApiRegistry.class);
    private final RestArgumentResolverComposite composite;
    private final HttpClientProvider provider;
    private ConfigurableListableBeanFactory beanFactory;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        ArrayList packageNames = new ArrayList();
        this.beanFactory.getBeansWithAnnotation(EnableRestApiProxy.class).forEach((key, value) -> {
            EnableRestApiProxy proxy = value.getClass().getAnnotation(EnableRestApiProxy.class);
            for (String basePackage : proxy.basePackages()) {
                if (!DataUtils.isNotBlank(basePackage)) continue;
                packageNames.add(basePackage);
            }
        });
        if (DataUtils.isNotEmpty(packageNames)) {
            try {
                Reflections reflections = new Reflections(packageNames.toArray());
                Set classSet = reflections.getTypesAnnotatedWith(RestService.class);
                if (CollectionUtils.isEmpty((Collection)classSet)) {
                    return;
                }
                classSet.forEach(clazz -> registry.registerBeanDefinition(clazz.getName(), this.generate((Class<?>)clazz)));
            }
            catch (IllegalStateException e) {
                log.error("\u521d\u59cb\u5316Rest\u6620\u5c04\u65f6\u51fa\u9519", (Throwable)e);
            }
            return;
        }
        throw new BeanDefinitionValidationException("\u3010RestApi\u3011EnableRestApiProxy\u6ce8\u89e3\u5fc5\u987b\u6307\u5b9a\u6709\u6548\u7684basePackage!");
    }

    private BeanDefinition generate(Class<?> clazz) {
        return BeanDefinitionBuilder.genericBeanDefinition(clazz, () -> RestProxyInvoker.produce(clazz, this)).setAutowireMode(2).getRawBeanDefinition();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isTrue((boolean)(beanFactory instanceof ConfigurableListableBeanFactory), (String)"\u5f53\u524dbean factory\u4e0d\u88ab\u652f\u6301\uff01");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public RestApiRegistry(RestArgumentResolverComposite composite, HttpClientProvider provider) {
        this.composite = composite;
        this.provider = provider;
    }

    public RestArgumentResolverComposite getComposite() {
        return this.composite;
    }

    public HttpClientProvider getProvider() {
        return this.provider;
    }
}

