/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.registry.proxy;

import com.fasterxml.jackson.databind.JavaType;
import group.flyfish.rest.annotation.AutoMapping;
import group.flyfish.rest.annotation.RestService;
import group.flyfish.rest.configuration.RestClientProperties;
import group.flyfish.rest.configuration.configure.PropertiesConfigurable;
import group.flyfish.rest.core.auth.RestAuthProvider;
import group.flyfish.rest.core.client.RestClient;
import group.flyfish.rest.core.client.RestClientBuilder;
import group.flyfish.rest.entity.Multipart;
import group.flyfish.rest.mapping.RestResultMapping;
import group.flyfish.rest.registry.RestApiRegistry;
import group.flyfish.rest.registry.proxy.RestInvokers;
import group.flyfish.rest.registry.proxy.entity.RestMethod;
import group.flyfish.rest.registry.proxy.support.ArgumentResolveContext;
import group.flyfish.rest.registry.proxy.support.RestArgumentResolverComposite;
import group.flyfish.rest.registry.proxy.support.UrlCompiler;
import group.flyfish.rest.registry.wrapper.DefaultRestResultMapping;
import group.flyfish.rest.utils.DataUtils;
import group.flyfish.rest.utils.JacksonUtil;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class RestProxyInvoker
implements InvocationHandler,
PropertiesConfigurable {
    private static final Logger log = LoggerFactory.getLogger(RestProxyInvoker.class);
    private final Map<Integer, RestMethod> methods = new ConcurrentHashMap<Integer, RestMethod>();
    private final Class<?> targetType;
    private final RestService restService;
    private RestClientProperties properties;
    private String baseUrl;
    private RequestConfig config;
    private final RestApiRegistry registry;
    private RestResultMapping mapping;
    private RestAuthProvider authProvider;

    private RestProxyInvoker(Class<?> targetType, RestApiRegistry registry) {
        this.targetType = targetType;
        this.registry = registry;
        this.restService = (RestService)AnnotationUtils.findAnnotation(targetType, RestService.class);
        Assert.notNull((Object)this.restService, (String)"\u5f53\u524d\u7c7b\u5c1a\u672a\u6dfb\u52a0@RestService\u6ce8\u89e3\uff01");
    }

    public static <T> T produce(Class<?> target, RestApiRegistry registry) {
        RestProxyInvoker invoker = new RestProxyInvoker(target, registry);
        RestInvokers.add(invoker);
        return DataUtils.cast(Proxy.newProxyInstance(target.getClassLoader(), new Class[]{target}, (InvocationHandler)invoker));
    }

    @Override
    public void configure(RestClientProperties properties) {
        this.properties = properties;
        this.config = RequestConfig.custom().setConnectTimeout((int)properties.getConnectionTimeout().toMillis()).setSocketTimeout(this.restService.timeout()).build();
        this.baseUrl = this.findBaseUrl();
        this.authProvider = this.determineAuthProvider();
    }

    @Override
    public Object invoke(Object proxy, Method target, Object[] args) throws Throwable {
        RestMethod method = this.methods.computeIfAbsent(target.hashCode(), k -> RestMethod.resolve(target, this));
        if (method.isInvalid()) {
            throw new IllegalAccessException("\u3010Rest\u8c03\u7528\u3011\u672a\u58f0\u660erest\u914d\u7f6e\u7684\u65b9\u6cd5\u88ab\u8c03\u7528\uff01\u8bf7\u68c0\u67e5\u4ee3\u7801\uff01");
        }
        RestArgumentResolverComposite composite = this.registry.getComposite();
        ArgumentResolveContext context = composite.resolve(method, args);
        RestClientBuilder builder = RestClient.create().url(this.resolveUrl(method.getUrl(), context)).method(method.getMethod()).config(this.config);
        if (method.isCredentials()) {
            builder.withCredential();
        }
        if (context.hasBody()) {
            builder.body(context.getBody());
        }
        if (context.hasMultipart()) {
            builder.multipart();
            context.getFiles().forEach((key, value) -> {
                value.setFilename(context.getFilename((String)key, value.getFilename()));
                builder.addMultipartBody((Multipart)value);
            });
        }
        if (context.hasParams()) {
            builder.queryParams(context.getParam());
        }
        if (context.hasHeaders()) {
            builder.headers(context.getHeaders());
        }
        if (null != this.authProvider) {
            this.authProvider.provide(builder);
        }
        RestClient client = builder.build();
        client.setClient(this.registry.getProvider());
        boolean map = null != this.mapping && method.isBare();
        Object result = this.execute(client, method, map);
        return map ? this.mapping.map(result) : result;
    }

    private Object execute(RestClient client, RestMethod method, boolean map) throws IOException {
        JavaType constructed = JacksonUtil.getMapper().constructType(method.getGenericReturnType());
        if (map) {
            Type resolved = this.mapping.resolve((Type)constructed);
            if (resolved instanceof JavaType) {
                return client.execute((JavaType)resolved);
            }
            if (resolved instanceof Class) {
                return client.execute((Class)resolved);
            }
        }
        if (ClassUtils.isAssignable(Map.class, method.getReturnType())) {
            return client.executeForMap();
        }
        return client.execute(constructed);
    }

    private String findBaseUrl() {
        if (null != this.restService) {
            String key = this.restService.value();
            String baseUrl = this.restService.baseUrl();
            AutoMapping autoMapping = (AutoMapping)AnnotationUtils.findAnnotation(this.targetType, AutoMapping.class);
            if (null != autoMapping) {
                Class clazz = autoMapping.value();
                this.mapping = Object.class.equals((Object)clazz) ? DefaultRestResultMapping.getInstance() : (RestResultMapping)RestResultMapping.MAPPINGS.get(clazz);
            }
            if (DataUtils.isNotBlank(key)) {
                return this.properties.getDictUrl(key);
            }
            if (DataUtils.isNotBlank(baseUrl)) {
                return baseUrl;
            }
        }
        return this.properties.getBaseUrl();
    }

    private String resolveUrl(String url, ArgumentResolveContext context) {
        return context.hasPathParams() ? UrlCompiler.compile(url, context.getPathParams()) : url;
    }

    private RestAuthProvider determineAuthProvider() {
        Class candidate = this.restService.authProvider();
        if (ClassUtils.isAssignable(RestAuthProvider.class, (Class)candidate)) {
            return (RestAuthProvider)candidate.newInstance();
        }
        return this.properties.getAuthProvider();
    }

    @Deprecated
    private Object passObjectMethod(Method method, Object[] args) {
        if (AopUtils.isEqualsMethod((Method)method)) {
            Object obj = args[0];
            return null != obj && ClassUtils.isAssignable(this.targetType, obj.getClass());
        }
        if (AopUtils.isHashCodeMethod((Method)method)) {
            return -1;
        }
        return null;
    }

    public RestClientProperties getProperties() {
        return this.properties;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

