/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.registry.proxy.entity;

import group.flyfish.rest.annotation.RestApi;
import group.flyfish.rest.enums.HttpMethod;
import group.flyfish.rest.registry.proxy.RestProxyInvoker;
import group.flyfish.rest.utils.DataUtils;
import java.beans.Transient;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationUtils;

public class RestMethod {
    private Parameter[] parameters;
    private boolean bare;
    private String url;
    private HttpMethod method;
    private boolean credentials;
    private boolean mergeBody;
    private Type genericReturnType;
    private Class<?> returnType;
    private boolean invalid;

    private RestMethod(Method method, RestProxyInvoker invoker) {
        this.init(method, invoker);
    }

    public static RestMethod resolve(Method method, RestProxyInvoker invoker) {
        return new RestMethod(method, invoker);
    }

    private void init(Method method, RestProxyInvoker invoker) {
        RestApi restApi = (RestApi)AnnotationUtils.findAnnotation((Method)method, RestApi.class);
        if (null == restApi) {
            this.invalid = true;
            return;
        }
        this.url = this.determineUrl(restApi, invoker);
        this.method = restApi.method();
        this.credentials = restApi.credentials();
        this.mergeBody = restApi.mergedBody();
        this.parameters = method.getParameters();
        this.bare = null != AnnotationUtils.findAnnotation((Method)method, Transient.class);
        this.genericReturnType = method.getGenericReturnType();
        this.returnType = method.getReturnType();
    }

    private String determineUrl(RestApi restApi, RestProxyInvoker invoker) {
        if (DataUtils.isNotBlank(restApi.url())) {
            return restApi.url();
        }
        return Stream.of(restApi.baseUrl(), invoker.getBaseUrl()).filter(DataUtils::isNotBlank).findFirst().map(found -> found.startsWith("#") ? invoker.getProperties().getDictUrl(found.substring(1)) : found).map(base -> base + restApi.uri()).orElseThrow(() -> new IllegalArgumentException("\u3010Rest\u8c03\u7528\u3011\u672a\u6307\u5b9aurl\u6216baseurl\uff0c\u65e0\u6cd5\u8c03\u7528\u8fdc\u7aef\u670d\u52a1\u5668\uff01"));
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public boolean isBare() {
        return this.bare;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public boolean isCredentials() {
        return this.credentials;
    }

    public boolean isMergeBody() {
        return this.mergeBody;
    }

    public Type getGenericReturnType() {
        return this.genericReturnType;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public boolean isInvalid() {
        return this.invalid;
    }
}

