/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.registry.proxy.support;

import group.flyfish.rest.entity.Multipart;
import group.flyfish.rest.registry.proxy.entity.RestMethod;
import group.flyfish.rest.utils.DataUtils;
import java.util.HashMap;
import java.util.Map;

public class ArgumentResolveContext {
    private RestMethod method;
    private Map<String, Object> param;
    private Map<String, Object> pathParams;
    private Map<String, String> headers;
    private Object body;
    private Map<String, Multipart> files;
    private Map<String, String> filenames;

    public void setParam(String key, Object value) {
        if (DataUtils.isEmpty(this.param)) {
            this.param = new HashMap<String, Object>();
        }
        this.param.put(key, value);
    }

    public void setBody(String key, Object value) {
        if (null == this.body || !(this.body instanceof Map)) {
            this.body = new HashMap();
        }
        Map map = (Map)DataUtils.cast(this.body);
        map.put(key, value);
    }

    public void setHeaders(Map<String, String> headers) {
        if (DataUtils.isEmpty(this.headers)) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.putAll(headers);
    }

    public void setHeader(String name, String value) {
        if (DataUtils.isEmpty(this.headers)) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    public void setPathParam(String key, Object value) {
        if (DataUtils.isEmpty(this.pathParams)) {
            this.pathParams = new HashMap<String, Object>();
        }
        this.pathParams.put(key, value);
    }

    public void setMultipart(String name, String filename, Object file) {
        this.setMultipart(new Multipart(name, filename, file));
    }

    public void addFilename(String part, String filename) {
        if (DataUtils.isEmpty(this.filenames)) {
            this.filenames = new HashMap<String, String>();
        }
        this.filenames.put(part, filename);
    }

    public void setMultipart(Multipart multipart) {
        if (DataUtils.isEmpty(this.files)) {
            this.files = new HashMap<String, Multipart>();
        }
        if (null != multipart && null != multipart.getData()) {
            this.files.put(multipart.getName(), multipart);
        }
    }

    public boolean hasPathParams() {
        return DataUtils.isNotEmpty(this.pathParams);
    }

    public boolean hasBody() {
        return null != this.body;
    }

    public boolean hasHeaders() {
        return DataUtils.isNotEmpty(this.headers);
    }

    public boolean hasParams() {
        return DataUtils.isNotEmpty(this.param);
    }

    public boolean hasMultipart() {
        return DataUtils.isNotEmpty(this.files);
    }

    public String getFilename(String part, String initial) {
        if (null == this.filenames || !this.filenames.containsKey(part)) {
            return initial;
        }
        return this.filenames.get(part);
    }

    ArgumentResolveContext(RestMethod method, Map<String, Object> param, Map<String, Object> pathParams, Map<String, String> headers, Object body, Map<String, Multipart> files, Map<String, String> filenames) {
        this.method = method;
        this.param = param;
        this.pathParams = pathParams;
        this.headers = headers;
        this.body = body;
        this.files = files;
        this.filenames = filenames;
    }

    public static ArgumentResolveContextBuilder builder() {
        return new ArgumentResolveContextBuilder();
    }

    public RestMethod getMethod() {
        return this.method;
    }

    public Map<String, Object> getParam() {
        return this.param;
    }

    public Map<String, Object> getPathParams() {
        return this.pathParams;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Object getBody() {
        return this.body;
    }

    public Map<String, Multipart> getFiles() {
        return this.files;
    }

    public Map<String, String> getFilenames() {
        return this.filenames;
    }

    public void setMethod(RestMethod method) {
        this.method = method;
    }

    public void setParam(Map<String, Object> param) {
        this.param = param;
    }

    public void setPathParams(Map<String, Object> pathParams) {
        this.pathParams = pathParams;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public void setFiles(Map<String, Multipart> files) {
        this.files = files;
    }

    public void setFilenames(Map<String, String> filenames) {
        this.filenames = filenames;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArgumentResolveContext)) {
            return false;
        }
        ArgumentResolveContext other = (ArgumentResolveContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RestMethod this$method = this.getMethod();
        RestMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Map<String, Object> this$param = this.getParam();
        Map<String, Object> other$param = other.getParam();
        if (this$param == null ? other$param != null : !((Object)this$param).equals(other$param)) {
            return false;
        }
        Map<String, Object> this$pathParams = this.getPathParams();
        Map<String, Object> other$pathParams = other.getPathParams();
        if (this$pathParams == null ? other$pathParams != null : !((Object)this$pathParams).equals(other$pathParams)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Object this$body = this.getBody();
        Object other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Map<String, Multipart> this$files = this.getFiles();
        Map<String, Multipart> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        Map<String, String> this$filenames = this.getFilenames();
        Map<String, String> other$filenames = other.getFilenames();
        return !(this$filenames == null ? other$filenames != null : !((Object)this$filenames).equals(other$filenames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArgumentResolveContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RestMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Map<String, Object> $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : ((Object)$param).hashCode());
        Map<String, Object> $pathParams = this.getPathParams();
        result = result * 59 + ($pathParams == null ? 43 : ((Object)$pathParams).hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Object $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Map<String, Multipart> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        Map<String, String> $filenames = this.getFilenames();
        result = result * 59 + ($filenames == null ? 43 : ((Object)$filenames).hashCode());
        return result;
    }

    public String toString() {
        return "ArgumentResolveContext(method=" + this.getMethod() + ", param=" + this.getParam() + ", pathParams=" + this.getPathParams() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ", files=" + this.getFiles() + ", filenames=" + this.getFilenames() + ")";
    }

    public static class ArgumentResolveContextBuilder {
        private RestMethod method;
        private Map<String, Object> param;
        private Map<String, Object> pathParams;
        private Map<String, String> headers;
        private Object body;
        private Map<String, Multipart> files;
        private Map<String, String> filenames;

        ArgumentResolveContextBuilder() {
        }

        public ArgumentResolveContextBuilder method(RestMethod method) {
            this.method = method;
            return this;
        }

        public ArgumentResolveContextBuilder param(Map<String, Object> param) {
            this.param = param;
            return this;
        }

        public ArgumentResolveContextBuilder pathParams(Map<String, Object> pathParams) {
            this.pathParams = pathParams;
            return this;
        }

        public ArgumentResolveContextBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public ArgumentResolveContextBuilder body(Object body) {
            this.body = body;
            return this;
        }

        public ArgumentResolveContextBuilder files(Map<String, Multipart> files) {
            this.files = files;
            return this;
        }

        public ArgumentResolveContextBuilder filenames(Map<String, String> filenames) {
            this.filenames = filenames;
            return this;
        }

        public ArgumentResolveContext build() {
            return new ArgumentResolveContext(this.method, this.param, this.pathParams, this.headers, this.body, this.files, this.filenames);
        }

        public String toString() {
            return "ArgumentResolveContext.ArgumentResolveContextBuilder(method=" + this.method + ", param=" + this.param + ", pathParams=" + this.pathParams + ", headers=" + this.headers + ", body=" + this.body + ", files=" + this.files + ", filenames=" + this.filenames + ")";
        }
    }
}

