/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.registry.proxy.support;

import group.flyfish.rest.registry.proxy.entity.RestMethod;
import group.flyfish.rest.registry.proxy.support.ArgumentResolveContext;
import group.flyfish.rest.registry.proxy.support.RestArgumentResolver;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.stream.IntStream;

public class RestArgumentResolverComposite {
    private final List<RestArgumentResolver> resolvers;

    public RestArgumentResolverComposite(List<RestArgumentResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public ArgumentResolveContext resolve(RestMethod method, Object[] args) {
        ArgumentResolveContext context = ArgumentResolveContext.builder().method(method).build();
        Parameter[] parameters = method.getParameters();
        IntStream.range(0, parameters.length).forEach(index -> this.resolveInternal(context, parameters[index], args[index]));
        return context;
    }

    private void resolveInternal(ArgumentResolveContext context, Parameter parameter, Object value) {
        this.resolvers.stream().filter(resolver -> resolver.support(parameter)).findFirst().ifPresent(resolver -> resolver.resolve(context, parameter, value));
    }
}

