/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.registry.proxy.support.resolvers;

import group.flyfish.rest.annotation.RestHeader;
import group.flyfish.rest.registry.proxy.support.ArgumentResolveContext;
import group.flyfish.rest.registry.proxy.support.RestArgumentResolver;
import group.flyfish.rest.utils.DataUtils;
import java.lang.reflect.Parameter;
import java.util.Map;

public class RestHeaderArgumentResolver
implements RestArgumentResolver {
    @Override
    public boolean support(Parameter parameter) {
        return parameter.isAnnotationPresent(RestHeader.class);
    }

    @Override
    public void resolve(ArgumentResolveContext context, Parameter parameter, Object value) {
        if (value instanceof Map) {
            ((Map)value).forEach((k, v) -> context.setHeader((String)k, String.valueOf(v)));
        } else {
            RestHeader header = parameter.getAnnotation(RestHeader.class);
            String name = DataUtils.isNotBlank(header.value()) ? header.value() : parameter.getName();
            context.setHeader(name, null != value ? String.valueOf(value) : "");
        }
    }
}

