/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.registry.proxy.support.resolvers;

import group.flyfish.rest.annotation.RestParam;
import group.flyfish.rest.annotation.RestParams;
import group.flyfish.rest.registry.proxy.support.ArgumentResolveContext;
import group.flyfish.rest.registry.proxy.support.RestArgumentResolver;
import group.flyfish.rest.utils.DataUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;

public class RestParamArgumentResolver
implements RestArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(RestParamArgumentResolver.class);

    @Override
    public boolean support(Parameter parameter) {
        return true;
    }

    @Override
    public void resolve(ArgumentResolveContext context, Parameter parameter, Object value) {
        if (null != parameter.getAnnotation(RestParams.class) || ClassUtils.isAssignable(Map.class, parameter.getType())) {
            this.resolveParams(context, parameter, value);
        } else {
            String name = Optional.ofNullable(parameter.getAnnotation(RestParam.class)).map(RestParam::value).filter(DataUtils::isNotBlank).orElse(parameter.getName());
            if (context.getMethod().isMergeBody()) {
                context.setBody(name, value);
            } else {
                context.setParam(name, value);
            }
        }
    }

    private void resolveParams(ArgumentResolveContext context, Parameter parameter, Object value) {
        if (null != parameter.getAnnotation(RestParam.class)) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u5c06\u5bf9\u8c61\u4f5c\u4e3a\u4e00\u4e2a\u666e\u901a\u7684\u53c2\u6570\uff01");
        }
        if (null != value) {
            if (ClassUtils.isAssignable(Map.class, parameter.getType())) {
                Map values = (Map)DataUtils.cast(value);
                values.forEach((k, v) -> {
                    if (null != v) {
                        context.setParam((String)k, String.valueOf(v));
                    }
                });
            } else {
                for (PropertyDescriptor propertyDescriptor : BeanUtils.getPropertyDescriptors(value.getClass())) {
                    if ("class".equalsIgnoreCase(propertyDescriptor.getName())) continue;
                    Object v2 = null;
                    try {
                        v2 = propertyDescriptor.getReadMethod().invoke(value, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        log.error("\u3010Rest\u5ba2\u6237\u7aef\u3011\u5c1d\u8bd5\u89e3\u6790\u53c2\u6570\u65f6\u53d1\u751f\u5f02\u5e38!\u83b7\u53d6bean\u7684\u5c5e\u6027\u8868\u5931\u8d25!{}", (Object)e.getMessage(), (Object)e);
                    }
                    if (null == v2) continue;
                    context.setParam(propertyDescriptor.getName(), String.valueOf(v2));
                }
            }
        }
    }
}

