/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.registry.proxy.support.resolvers;

import group.flyfish.rest.annotation.RestPart;
import group.flyfish.rest.entity.Multipart;
import group.flyfish.rest.registry.proxy.support.ArgumentResolveContext;
import group.flyfish.rest.registry.proxy.support.RestArgumentResolver;
import java.lang.reflect.Parameter;

public class RestPartArgumentResolver
implements RestArgumentResolver {
    @Override
    public boolean support(Parameter parameter) {
        return parameter.isAnnotationPresent(RestPart.class);
    }

    @Override
    public void resolve(ArgumentResolveContext context, Parameter parameter, Object value) {
        RestPart part = parameter.getAnnotation(RestPart.class);
        if (value instanceof Multipart) {
            context.setMultipart((Multipart)value);
        } else if (null != value) {
            context.setMultipart(part.value(), null, value);
        }
    }

    public static class FilenameResolver
    implements RestArgumentResolver {
        @Override
        public boolean support(Parameter parameter) {
            return parameter.isAnnotationPresent(RestPart.Filename.class);
        }

        @Override
        public void resolve(ArgumentResolveContext context, Parameter parameter, Object value) {
            if (value instanceof String) {
                RestPart.Filename filename = parameter.getAnnotation(RestPart.Filename.class);
                context.addFilename(filename.value(), (String)value);
            }
        }
    }
}

