/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.registry.wrapper;

import group.flyfish.rest.core.exception.RestClientException;
import group.flyfish.rest.mapping.RestResultMapping;
import group.flyfish.rest.registry.wrapper.RestResult;
import group.flyfish.rest.utils.TypeResolveUtils;
import java.lang.reflect.Type;
import java.util.Date;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRestResultMapping
implements RestResultMapping {
    private static final Logger log = LoggerFactory.getLogger(DefaultRestResultMapping.class);

    public static DefaultRestResultMapping getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public <T> T map(Object body) throws RestClientException {
        if (body instanceof RestResult) {
            RestResult result = (RestResult)body;
            if (result.isSuccess()) {
                return result.getResult();
            }
            log.error("\u3010RestProxy\u3011\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff01\u72b6\u6001\u7801\uff1a{}\uff0c\u65f6\u95f4\uff1a{}\uff0c\u4fe1\u606f\uff1a{}", new Object[]{result.getCode(), DateUtils.formatDate((Date)new Date(result.getTimestamp()), (String)"yyyy-MM-dd HH:mm:ss"), result.getMessage()});
            throw new RestClientException(result.getMessage());
        }
        return (T)body;
    }

    public Type resolve(Type resultType) {
        return TypeResolveUtils.wrap(resultType, RestResult.class);
    }

    private static interface SingletonHolder {
        public static final DefaultRestResultMapping INSTANCE = new DefaultRestResultMapping();
    }
}

