/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class JacksonUtil {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <T> T fromJson(String json) {
        return JacksonUtil.readValue(json, new TypeReference<T>(){});
    }

    public static <T> T fromJson(String json, TypeReference<T> reference) {
        return JacksonUtil.readValue(json, reference);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        if (null == json || "".equals(json)) {
            return null;
        }
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T fromJson(String json, JavaType type) {
        if (null == json || "".equals(json)) {
            return null;
        }
        try {
            return (T)mapper.readValue(json, type);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <K, V> Map<K, V> json2Map(String json) {
        return (Map)JacksonUtil.readValue(json, new TypeReference<Map<K, V>>(){});
    }

    public static <T> List<T> json2List(String json) {
        return (List)JacksonUtil.readValue(json, new TypeReference<List<T>>(){});
    }

    public static <T> List<T> json2List(String json, Class<T> clazz) {
        if (null == json || "".equals(json)) {
            return Collections.emptyList();
        }
        try {
            return (List)mapper.readValue(json, mapper.getTypeFactory().constructParametricType(List.class, new Class[]{clazz}));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static Optional<String> toJson(Object obj) {
        try {
            return Optional.of(mapper.writeValueAsString(obj));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private static <T> T readValue(String json, TypeReference<T> valueTypeRef) {
        if (null == json || "".equals(json)) {
            return null;
        }
        try {
            return (T)mapper.readValue(json, valueTypeRef);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObjectMapper getMapper() {
        return mapper;
    }

    static {
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
    }
}

