/*
 * Decompiled with CFR 0.152.
 */
package group.flyfish.rest.utils;

import group.flyfish.rest.utils.DataUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class RequestContext {
    public static final String AUTHORIZATION_KEY = "Authorization";

    public static Optional<HttpServletRequest> getRequest() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes instanceof ServletRequestAttributes) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)attributes;
            return Optional.ofNullable(servletRequestAttributes.getRequest());
        }
        return Optional.empty();
    }

    public static Optional<HttpServletResponse> getResponse() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes instanceof ServletRequestAttributes) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)attributes;
            return Optional.ofNullable(servletRequestAttributes.getResponse());
        }
        return Optional.empty();
    }

    public static List<Cookie> getCookies() {
        return RequestContext.getRequest().flatMap(request -> Optional.ofNullable(request.getCookies())).map(cookies -> Arrays.stream(cookies).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static List<Cookie> getCookies(Predicate<? super Cookie> predicate) {
        return RequestContext.getRequest().flatMap(request -> Optional.ofNullable(request.getCookies())).map(cookies -> Arrays.stream(cookies).filter(predicate).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static Optional<String> getCredential() {
        return RequestContext.getRequest().map(request -> request.getHeader(AUTHORIZATION_KEY)).filter(DataUtils::isNotBlank).map(Optional::of).orElseGet(() -> RequestContext.getCookies(cookie -> AUTHORIZATION_KEY.equals(cookie.getName())).stream().findAny().map(Cookie::getValue));
    }
}

