package group.flyfish.rest.annotation;

import group.flyfish.rest.configuration.RestClientConfiguration;
import org.springframework.context.annotation.Import;

import java.lang.annotation.*;

/**
 * 启用restapi自动代理
 *
 * @author wangyu
 */
@Import(RestClientConfiguration.class)
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface EnableRestApiProxy {

    /**
     * 基本扫描路径
     *
     * @return 结果
     */
    String[] basePackages() default "group.flyfish.rest";
}
