package group.flyfish.rest.core.builder;

import group.flyfish.rest.utils.JacksonUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * 有具体泛型类型的Map构建器
 * 提供基本的非空校验
 *
 * @author Mr.Wang
 */
public final class TypedMapBuilder<K, V> {

    private final Map<K, V> params;

    private TypedMapBuilder() {
        this.params = new HashMap<>();
    }

    public static <K, V> TypedMapBuilder<K, V> builder() {
        return new TypedMapBuilder<>();
    }

    public static TypedMapBuilder<String, String> stringMapBuilder() {
        return new TypedMapBuilder<>();
    }

    public static TypedMapBuilder<String, Object> stringObjectBuilder() {
        return new TypedMapBuilder<>();
    }

    public TypedMapBuilder<K, V> with(K key, V value) {
        if (key != null && value != null) {
            this.params.put(key, value);
        }
        return this;
    }

    public TypedMapBuilder<K, V> withAll(Map<K, V> values) {
        values.forEach(this::with);
        return this;
    }

    public Map<K, V> build() {
        return params;
    }

    @Override
    public String toString() {
        return JacksonUtil.toJson(this).orElse(null);
    }
}
