package group.flyfish.rest.core.exception;

import lombok.Getter;

/**
 * 异常类，用于包装异常
 */
public class RestClientException extends RuntimeException {

    private static final long serialVersionUID = 4741281547788724661L;
    @Getter
    private Exception nested;

    @Getter
    private int statusCode;

    private Object bind;

    public RestClientException(String message, Exception nested) {
        super(message);
        this.nested = nested;
    }

    public RestClientException(String message, int statusCode, Object bind) {
        super(message);
        this.statusCode = statusCode;
        this.bind = bind;
    }

    public RestClientException(String message) {
        super(message);
    }

    @SuppressWarnings("unchecked")
    public <T> T getBind() {
        return (T) bind;
    }
}
