package group.flyfish.rest.core.factory;

import group.flyfish.rest.configuration.RestClientProperties;
import group.flyfish.rest.configuration.configure.PropertiesConfigurable;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

/**
 * 默认的http客户端提供者
 *
 * @author wangyu
 */
public class DefaultHttpClientProvider implements HttpClientProvider, BeanFactoryAware, PropertiesConfigurable {

    private CloseableHttpClient client;

    private BeanFactory beanFactory;

    /**
     * 获取client，可以自由替换
     *
     * @return 结果
     */
    @Override
    public CloseableHttpClient getClient() {
        return client;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    /**
     * 配置属性，完成初始化
     *
     * @param properties 属性
     */
    @Override
    public void configure(RestClientProperties properties) {
        this.client = beanFactory.getBean(CloseableHttpClient.class);
    }
}
