package group.flyfish.rest.core.resolver;

import group.flyfish.rest.core.client.RestClientBuilder;
import group.flyfish.rest.core.resolver.support.AbstractParamResolver;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;

/**
 * 删除请求的解析器
 *
 * @author wangyu
 */
public class HttpDeleteResolver extends AbstractParamResolver implements HttpMethodResolver {

    /**
     * 解析请求
     *
     * @param builder 构建器
     * @return 结果
     */
    @Override
    public HttpRequestBase resolve(RestClientBuilder builder) {
        return new HttpDelete(resolveParams(builder).getUrl());
    }
}
