package group.flyfish.rest.core.resolver;

import group.flyfish.rest.core.client.RestClientBuilder;
import group.flyfish.rest.core.resolver.support.AbstractParamResolver;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

/**
 * Get方法解析参数的解析器
 */
public class HttpGetResolver extends AbstractParamResolver implements HttpMethodResolver {

    @Override
    public HttpRequestBase resolve(RestClientBuilder builder) {
        return new HttpGet(resolveParams(builder).getUrl());
    }
}
