package group.flyfish.rest.core.resolver;

import group.flyfish.rest.core.client.RestClientBuilder;
import group.flyfish.rest.core.resolver.support.AbstractBodyResolver;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpRequestBase;

/**
 * patch请求的解析器
 *
 * @author wangyu
 */
public class HttpPatchResolver extends AbstractBodyResolver implements HttpMethodResolver {

    /**
     * 解析请求
     *
     * @param builder 构建器
     * @return 结果
     */
    @Override
    public HttpRequestBase resolve(RestClientBuilder builder) {
        HttpPatch httpPatch = new HttpPatch(builder.getUrl());
        httpPatch.setEntity(buildEntity(builder));
        return httpPatch;
    }
}
