package group.flyfish.rest.core.resolver;

import group.flyfish.rest.core.client.RestClientBuilder;
import group.flyfish.rest.core.resolver.support.AbstractBodyResolver;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;

/**
 * Post方法解析参数的解析器，包括上传
 */
public class HttpPostResolver extends AbstractBodyResolver implements HttpMethodResolver {

    @Override
    public HttpRequestBase resolve(RestClientBuilder builder) {
        HttpEntity entity = buildEntity(builder);
        HttpPost post = new HttpPost(builder.getUrl());
        post.setEntity(entity);
        return post;
    }

}
