package group.flyfish.rest.core.resolver;

import group.flyfish.rest.core.client.RestClientBuilder;
import group.flyfish.rest.core.resolver.support.AbstractBodyResolver;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;

/**
 * put请求解析器
 *
 * @author wangyu
 */
public class HttpPutResolver extends AbstractBodyResolver implements HttpMethodResolver {

    /**
     * 解析请求
     *
     * @param builder 构建器
     * @return 结果
     */
    @Override
    public HttpRequestBase resolve(RestClientBuilder builder) {
        HttpPut post = new HttpPut(builder.getUrl());
        post.setEntity(buildEntity(builder));
        return post;
    }
}
