package group.flyfish.rest.core.resolver.support;

import group.flyfish.rest.core.client.RestClientBuilder;
import group.flyfish.rest.utils.DataUtils;

import java.util.stream.Collectors;

/**
 * 抽象的参数解析逻辑
 *
 * @author wangyu
 */
public abstract class AbstractParamResolver {

    /**
     * 解析参数
     *
     * @param builder 构建器
     */
    protected RestClientBuilder resolveParams(RestClientBuilder builder) {
        if (DataUtils.isNotEmpty(builder.getParams())) {
            String start = builder.getUrl().contains("?") ? "&" : "?";
            String params = builder.getParams().entrySet().stream()
                    .map(entry -> entry.getKey() + "=" + valueOf(entry.getValue()))
                    .collect(Collectors.joining("&"));
            builder.url(builder.getUrl() + start + params);
        }
        return builder;
    }

    /**
     * 解析值
     *
     * @param value 值
     * @return 结果
     */
    private String valueOf(Object value) {
        if (value instanceof String) {
            return (String) value;
        }
        if (null != value) {
            return String.valueOf(value);
        }
        return "";
    }
}
