package group.flyfish.rest.registry.proxy;

import group.flyfish.rest.configuration.RestClientProperties;

import java.util.ArrayList;
import java.util.List;

/**
 * rest执行器实例集合
 *
 * @author wangyu
 */
public class RestInvokers {

    private static RestClientProperties properties;

    private static List<RestProxyInvoker> invokers = new ArrayList<>();

    public static void add(RestProxyInvoker invoker) {
        if (null != properties) {
            invoker.configure(properties);
        } else {
            invokers.add(invoker);
        }
    }

    public static synchronized void configure(RestClientProperties properties) {
        invokers.forEach(invoker -> invoker.configure(properties));
        invokers.clear();
        invokers = null;
        RestInvokers.properties = properties;
    }
}
