package group.flyfish.rest.registry.proxy.support;

import java.lang.reflect.Parameter;

/**
 * 参数解析器
 *
 * @author wangyu
 */
public interface RestArgumentResolver {

    /**
     * 是否支持
     *
     * @param parameter 参数
     * @return 结果
     */
    boolean support(Parameter parameter);

    /**
     * 解析
     *
     * @param context   上下文，赋值
     * @param parameter 参数
     * @param value     值
     */
    void resolve(ArgumentResolveContext context, Parameter parameter, Object value);
}
