package group.flyfish.rest.registry.proxy.support;

import group.flyfish.rest.registry.proxy.entity.RestMethod;

import java.lang.reflect.Parameter;
import java.util.List;
import java.util.stream.IntStream;

/**
 * 解析器集合
 *
 * @author wangyu
 */
public class RestArgumentResolverComposite {

    // 解析器们
    private final List<RestArgumentResolver> resolvers;

    public RestArgumentResolverComposite(List<RestArgumentResolver> resolvers) {
        this.resolvers = resolvers;
    }

    /**
     * 执行解析
     *
     * @param method 方法
     * @param args   参数
     * @return 结果
     */
    public ArgumentResolveContext resolve(RestMethod method, Object[] args) {
        // 上下文
        ArgumentResolveContext context = ArgumentResolveContext.builder().method(method).build();
        // 参数元
        Parameter[] parameters = method.getParameters();
        // 循环处理
        IntStream.range(0, parameters.length)
                .forEach(index -> resolveInternal(context, parameters[index], args[index]));
        return context;
    }

    /**
     * 内部解析
     *
     * @param context   上下文
     * @param parameter 参数
     * @param value     值
     */
    private void resolveInternal(ArgumentResolveContext context, Parameter parameter, Object value) {
        // 开始解析
        resolvers.stream().filter(resolver -> resolver.support(parameter)).findFirst()
                .ifPresent(resolver -> resolver.resolve(context, parameter, value));
    }
}
