package group.flyfish.rest.registry.proxy.support;

import group.flyfish.rest.core.builder.MapParamBuilder;
import group.flyfish.rest.utils.DataUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * url编译器
 *
 * @author wangyu
 */
public class UrlCompiler {

    // 匹配正则预编译
    private static final Pattern PATTERN = Pattern.compile("\\{\\w+}");

    /**
     * 地址原路径编译
     *
     * @param source 源
     * @return 结果
     */
    public static String compile(String source, Map<String, Object> params) {
        Matcher matcher = PATTERN.matcher(source);
        // 开始查找和替换
        while (matcher.find()) {
            String found = matcher.group();
            String key = DataUtils.substringBetween(found, "{", "}");
            if (params.containsKey(key)) {
                source = source.replace(found, String.valueOf(params.get(key)));
            }
        }
        return source;
    }

    /**
     * 测试
     *
     * @param args args参数
     */
    public static void main(String[] args) {
        String result = UrlCompiler.compile("http://www.baidu.com/love/{target}/{mobile}/{shit}", MapParamBuilder.builder()
                .with("target", "nanami")
                .with("mobile", 1223123)
                .with("shit", new HashMap<>())
                .build());
        System.out.println(result);
    }
}
