package group.flyfish.rest.registry.proxy.support.resolvers;

import group.flyfish.rest.annotation.RestBody;
import group.flyfish.rest.registry.proxy.support.ArgumentResolveContext;
import group.flyfish.rest.registry.proxy.support.RestArgumentResolver;

import java.lang.reflect.Parameter;

/**
 * 请求体参数解析
 *
 * @author wangyu
 */
public class RestBodyArgumentResolver implements RestArgumentResolver {

    /**
     * 是否支持
     *
     * @param parameter 参数
     * @return 结果
     */
    @Override
    public boolean support(Parameter parameter) {
        return parameter.isAnnotationPresent(RestBody.class);
    }

    /**
     * 解析
     *
     * @param context   上下文，赋值
     * @param parameter 参数
     * @param value     值
     */
    @Override
    public void resolve(ArgumentResolveContext context, Parameter parameter, Object value) {
        // 无视合并body，这里的优先级最高
        context.setBody(value);
    }
}
