package group.flyfish.rest.registry.proxy.support.resolvers;

import group.flyfish.rest.annotation.RestHeader;
import group.flyfish.rest.registry.proxy.support.ArgumentResolveContext;
import group.flyfish.rest.registry.proxy.support.RestArgumentResolver;
import group.flyfish.rest.utils.DataUtils;

import java.lang.reflect.Parameter;
import java.util.Map;

/**
 * 请求头解析策略
 *
 * @author wangyu
 */
public class RestHeaderArgumentResolver implements RestArgumentResolver {

    /**
     * 是否支持
     *
     * @param parameter 参数
     * @return 结果
     */
    @Override
    public boolean support(Parameter parameter) {
        return parameter.isAnnotationPresent(RestHeader.class);
    }

    /**
     * 解析
     *
     * @param context   上下文，赋值
     * @param parameter 参数
     * @param value     值
     */
    @Override
    public void resolve(ArgumentResolveContext context, Parameter parameter, Object value) {
        if (value instanceof Map) {
            ((Map<?, ?>) value).forEach((k, v) -> context.setHeader((String) k, String.valueOf(v)));
        } else {
            RestHeader header = parameter.getAnnotation(RestHeader.class);
            String name = DataUtils.isNotBlank(header.value()) ? header.value() : parameter.getName();
            context.setHeader(name, null != value ? String.valueOf(value) : "");
        }
    }
}
