package group.flyfish.rest.registry.proxy.support.resolvers;

import group.flyfish.rest.annotation.RestPart;
import group.flyfish.rest.entity.Multipart;
import group.flyfish.rest.registry.proxy.support.ArgumentResolveContext;
import group.flyfish.rest.registry.proxy.support.RestArgumentResolver;

import java.lang.reflect.Parameter;

/**
 * 文件上传参数处理器
 *
 * @author wangyu
 */
public class RestPartArgumentResolver implements RestArgumentResolver {

    /**
     * 是否支持
     *
     * @param parameter 参数
     * @return 结果
     */
    @Override
    public boolean support(Parameter parameter) {
        return parameter.isAnnotationPresent(RestPart.class);
    }

    /**
     * 解析
     *
     * @param context   上下文，赋值
     * @param parameter 参数
     * @param value     值
     */
    @Override
    public void resolve(ArgumentResolveContext context, Parameter parameter, Object value) {
        RestPart part = parameter.getAnnotation(RestPart.class);
        if (value instanceof Multipart) {
            context.setMultipart((Multipart) value);
        } else if (null != value) {
            context.setMultipart(part.value(), null, value);
        }
    }

    /**
     * 解析和处理文件名
     */
    public static class FilenameResolver implements RestArgumentResolver {

        /**
         * 是否支持
         *
         * @param parameter 参数
         * @return 结果
         */
        @Override
        public boolean support(Parameter parameter) {
            return parameter.isAnnotationPresent(RestPart.Filename.class);
        }

        /**
         * 解析
         *
         * @param context   上下文，赋值
         * @param parameter 参数
         * @param value     值
         */
        @Override
        public void resolve(ArgumentResolveContext context, Parameter parameter, Object value) {
            if (value instanceof String) {
                RestPart.Filename filename = parameter.getAnnotation(RestPart.Filename.class);
                context.addFilename(filename.value(), (String) value);
            }
        }
    }
}
