package group.flyfish.rest.registry.proxy.support.resolvers;

import group.flyfish.rest.annotation.RestPathParam;
import group.flyfish.rest.registry.proxy.support.ArgumentResolveContext;
import group.flyfish.rest.registry.proxy.support.RestArgumentResolver;
import group.flyfish.rest.utils.DataUtils;

import java.lang.reflect.Parameter;

/**
 * 解析路径参数
 *
 * @author wangyu
 */
public class RestPathParamArgumentResolver implements RestArgumentResolver {

    /**
     * 是否支持
     *
     * @param parameter 参数
     * @return 结果
     */
    @Override
    public boolean support(Parameter parameter) {
        return parameter.isAnnotationPresent(RestPathParam.class);
    }

    /**
     * 解析
     *
     * @param context   上下文，赋值
     * @param parameter 参数
     * @param value     值
     */
    @Override
    public void resolve(ArgumentResolveContext context, Parameter parameter, Object value) {
        RestPathParam annotation = parameter.getAnnotation(RestPathParam.class);
        String name = DataUtils.isNotBlank(annotation.value()) ? annotation.value() : parameter.getName();
        context.setPathParam(parameter.getName(), value);
    }
}
