package group.flyfish.rest.registry.wrapper;

import lombok.Data;

/**
 * 标准的解包结构，等同于全局
 *
 * @author wangyu
 */
@Data
public class RestResult<T> {

    /**
     * 成功标志
     */
    private boolean success = true;

    /**
     * 返回处理消息
     */
    private String message = "操作成功！";

    /**
     * 返回代码
     */
    private Integer code = 0;

    /**
     * 返回数据对象 data
     */
    private T result;

    /**
     * 时间戳
     */
    private long timestamp = System.currentTimeMillis();
}
