package group.flyfish.rest.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;

import java.lang.reflect.Type;

/**
 * 类型解析工具类
 *
 * @author wangyu
 */
public final class TypeResolveUtils {

    /**
     * 使用包装类包装
     *
     * @param origin  原类型
     * @param wrapper 包装类型
     * @return 结果
     */
    public static Type wrap(Type origin, Class<?> wrapper) {
        // 构建泛型的返回值
        TypeFactory typeFactory = JacksonUtil.getMapper().getTypeFactory();
        if (origin instanceof Class) {
            return typeFactory.constructParametricType(wrapper, (Class<?>) origin);
        } else if (origin instanceof JavaType) {
            return typeFactory.constructParametricType(wrapper, (JavaType) origin);
        }
        // 无法解析，未知类型
        return origin;
    }
}
