/*
 * Decompiled with CFR 0.152.
 */
package group.rxcloud.vrml.core.beans;

import group.rxcloud.vrml.core.beans.AppContext;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public final class SpringContextConfigurator
implements ApplicationContextAware,
DisposableBean {
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        AppContext.setApplicationContext(applicationContext);
    }

    public static void setStaticApplicationContext(ApplicationContext applicationContext) {
        AppContext.setApplicationContext(applicationContext);
    }

    public static ApplicationContext getApplicationContext() {
        return AppContext.getApplicationContext();
    }

    public static <T> T getBean(String name) {
        return (T)AppContext.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(String name, T defaultBean) {
        Object bean = AppContext.getApplicationContext().getBean(name);
        return (T)(bean == null ? defaultBean : bean);
    }

    public static <T> void loadBean(Class<T> requiredType) {
        AppContext.getApplicationContext().getBean(requiredType);
    }

    public static <T> T getBean(Class<T> requiredType) {
        return (T)AppContext.getApplicationContext().getBean(requiredType);
    }

    public static <T> Map<String, T> getBeans(Class<T> requiredType) {
        return AppContext.getApplicationContext().getBeansOfType(requiredType);
    }

    public static <T> T getBean(Class<T> requiredType, T defaultBean) {
        Object bean = AppContext.getApplicationContext().getBean(requiredType);
        return (T)(bean == null ? defaultBean : bean);
    }

    public void destroy() throws Exception {
        AppContext.clear();
    }
}

