/*
 * Decompiled with CFR 0.152.
 */
package ch.ahdis.matchbox.mappinglanguage;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;

class ElementSortComparator
implements Comparator<Element> {
    private List<String> children;

    public ElementSortComparator(Element e, Property property) {
        String tn = e.getType();
        StructureDefinition sd = (StructureDefinition)property.getContext().fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + tn);
        this.children = new ArrayList<String>();
        if (sd != null && !sd.getAbstract()) {
            for (ElementDefinition def : sd.getSnapshot().getElement()) {
                this.children.add(def.getPath());
            }
        } else {
            for (ElementDefinition def : property.getStructure().getSnapshot().getElement()) {
                this.children.add(def.getPath());
            }
        }
    }

    @Override
    public int compare(Element e0, Element e1) {
        int i0 = this.find(e0);
        int i1 = this.find(e1);
        return Integer.compare(i0, i1);
    }

    private int find(Element e0) {
        int i = e0.getElementProperty() != null ? this.children.indexOf(e0.getElementProperty().getDefinition().getPath()) : this.children.indexOf(e0.getProperty().getDefinition().getPath());
        return i;
    }
}

