/*
 * Decompiled with CFR 0.152.
 */
package ch.ahdis.matchbox.mappinglanguage;

import ch.ahdis.matchbox.mappinglanguage.ConceptMapEngine;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.structuremap.ITransformerServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformSupportServices
implements ITransformerServices {
    private List<Base> outputs;
    private IWorkerContext context;
    protected static final Logger log = LoggerFactory.getLogger(TransformSupportServices.class);

    public TransformSupportServices(IWorkerContext worker, List<Base> outputs) {
        this.context = worker;
        this.outputs = outputs;
    }

    public Base createType(Object appInfo, String name) throws FHIRException {
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, name);
        return Manager.build((IWorkerContext)this.context, (StructureDefinition)sd);
    }

    public Base createResource(Object appInfo, Base res, boolean atRootofTransform) {
        if (atRootofTransform) {
            this.outputs.add(res);
        }
        return res;
    }

    public Coding translate(Object appInfo, Coding source, String conceptMapUrl) throws FHIRException {
        ConceptMapEngine cme = new ConceptMapEngine(this.context);
        return cme.translate(source, conceptMapUrl);
    }

    public Base resolveReference(Object appContext, String url) throws FHIRException {
        Resource resource = this.context.fetchResource(Resource.class, url);
        return resource;
    }

    public List<Base> performSearch(Object appContext, String url) throws FHIRException {
        throw new FHIRException("performSearch is not supported yet");
    }

    public void log(String message) {
        log.debug(message);
    }
}

