/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.NoTerminologyServiceException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.CanonicalResourceManager;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.context.SystemOutLoggingService;
import org.hl7.fhir.r5.context.TerminologyCache;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.renderers.OperationOutcomeRenderer;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.terminologies.client.ITerminologyClient;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientContext;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpander;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.validation.VSCheckerException;
import org.hl7.fhir.r5.terminologies.validation.ValueSetValidator;
import org.hl7.fhir.r5.utils.PackageHackerR5;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public abstract class BaseWorkerContext
extends I18nBase
implements IWorkerContext {
    private static final boolean QA_CHECK_REFERENCE_SOURCE = false;
    private Object lock = new Object();
    protected String version;
    protected TerminologyClientContext tcc = new TerminologyClientContext();
    private boolean minimalMemory = false;
    private Map<String, Map<String, ResourceProxy>> allResourcesById = new HashMap<String, Map<String, ResourceProxy>>();
    private CanonicalResourceManager<CodeSystem> codeSystems = new CanonicalResourceManager(false, this.minimalMemory);
    private final Set<String> supportedCodeSystems = new HashSet<String>();
    private final Set<String> unsupportedCodeSystems = new HashSet<String>();
    private CanonicalResourceManager<ValueSet> valueSets = new CanonicalResourceManager(false, this.minimalMemory);
    private CanonicalResourceManager<ConceptMap> maps = new CanonicalResourceManager(false, this.minimalMemory);
    protected CanonicalResourceManager<StructureMap> transforms = new CanonicalResourceManager(false, this.minimalMemory);
    private CanonicalResourceManager<StructureDefinition> structures = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<Measure> measures = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<Library> libraries = new CanonicalResourceManager(false, this.minimalMemory);
    private CanonicalResourceManager<ImplementationGuide> guides = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<CapabilityStatement> capstmts = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<SearchParameter> searchParameters = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<Questionnaire> questionnaires = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<OperationDefinition> operations = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<PlanDefinition> plans = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<ActorDefinition> actors = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<Requirements> requirements = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<NamingSystem> systems = new CanonicalResourceManager(false, this.minimalMemory);
    private Map<String, NamingSystem> systemUrlMap;
    private UcumService ucumService;
    protected Map<String, byte[]> binaries = new HashMap<String, byte[]>();
    protected Map<String, String> oidCache = new HashMap<String, String>();
    protected Map<String, Map<String, IWorkerContext.ValidationResult>> validationCache = new HashMap<String, Map<String, IWorkerContext.ValidationResult>>();
    protected String name;
    private boolean allowLoadingDuplicates;
    private final Set<String> codeSystemsUsed = new HashSet<String>();
    protected ToolingClientLogger txLog;
    private boolean canRunWithoutTerminology;
    protected boolean noTerminologyServer;
    private int expandCodesLimit = 1000;
    protected IWorkerContext.ILoggingService logger = new SystemOutLoggingService();
    protected Parameters expParameters;
    private TranslationServices translator = new NullTranslator();
    private Map<String, PackageInformation> packages = new HashMap<String, PackageInformation>();
    protected TerminologyCache txCache;
    protected TimeTracker clock;
    private boolean tlogging = true;
    private IWorkerContextManager.ICanonicalResourceLocator locator;
    protected String userAgent;
    private Set<String> notCanonical = new HashSet<String>();
    protected IWorkerContextManager.IPackageLoadingTracker packageTracker;
    private boolean forPublication;
    private boolean cachingAllowed = true;

    protected BaseWorkerContext() throws FileNotFoundException, IOException, FHIRException {
        this.setValidationMessageLanguage(this.getLocale());
        this.clock = new TimeTracker();
    }

    protected BaseWorkerContext(Locale locale) throws FileNotFoundException, IOException, FHIRException {
        this.setValidationMessageLanguage(locale);
        this.clock = new TimeTracker();
    }

    protected BaseWorkerContext(CanonicalResourceManager<CodeSystem> codeSystems, CanonicalResourceManager<ValueSet> valueSets, CanonicalResourceManager<ConceptMap> maps, CanonicalResourceManager<StructureDefinition> profiles, CanonicalResourceManager<ImplementationGuide> guides) throws FileNotFoundException, IOException, FHIRException {
        this();
        this.codeSystems = codeSystems;
        this.valueSets = valueSets;
        this.maps = maps;
        this.structures = profiles;
        this.guides = guides;
        this.clock = new TimeTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(BaseWorkerContext other) {
        Object object = other.lock;
        synchronized (object) {
            this.allResourcesById.putAll(other.allResourcesById);
            this.translator = other.translator;
            this.codeSystems.copy(other.codeSystems);
            this.valueSets.copy(other.valueSets);
            this.maps.copy(other.maps);
            this.transforms.copy(other.transforms);
            this.structures.copy(other.structures);
            this.searchParameters.copy(other.searchParameters);
            this.plans.copy(other.plans);
            this.questionnaires.copy(other.questionnaires);
            this.operations.copy(other.operations);
            this.systems.copy(other.systems);
            this.systemUrlMap = null;
            this.guides.copy(other.guides);
            this.capstmts.copy(other.capstmts);
            this.measures.copy(other.measures);
            this.libraries.copy(this.libraries);
            this.allowLoadingDuplicates = other.allowLoadingDuplicates;
            this.name = other.name;
            this.txLog = other.txLog;
            this.canRunWithoutTerminology = other.canRunWithoutTerminology;
            this.noTerminologyServer = other.noTerminologyServer;
            if (other.txCache != null) {
                this.txCache = other.txCache;
            }
            this.expandCodesLimit = other.expandCodesLimit;
            this.logger = other.logger;
            this.expParameters = other.expParameters;
            this.version = other.version;
            this.supportedCodeSystems.addAll(other.supportedCodeSystems);
            this.unsupportedCodeSystems.addAll(other.unsupportedCodeSystems);
            this.codeSystemsUsed.addAll(other.codeSystemsUsed);
            this.ucumService = other.ucumService;
            this.binaries.putAll(other.binaries);
            this.oidCache.putAll(other.oidCache);
            this.validationCache.putAll(other.validationCache);
            this.tlogging = other.tlogging;
            this.locator = other.locator;
            this.userAgent = other.userAgent;
            this.tcc.copy(other.tcc);
            this.cachingAllowed = other.cachingAllowed;
        }
    }

    public void cacheResource(Resource r) throws FHIRException {
        this.cacheResourceFromPackage(r, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResourceFromPackage(CanonicalResourceManager.CanonicalResourceProxy r, PackageInformation packageInfo) throws FHIRException {
        PackageHackerR5.fixLoadedResource((CanonicalResourceManager.CanonicalResourceProxy)r, (PackageInformation)packageInfo);
        Object object = this.lock;
        synchronized (object) {
            if (packageInfo != null) {
                this.packages.put(packageInfo.getVID(), packageInfo);
            }
            if (r.getId() != null) {
                Map<String, ResourceProxy> map = this.allResourcesById.get(r.getType());
                if (map == null) {
                    map = new HashMap<String, ResourceProxy>();
                    this.allResourcesById.put(r.getType(), map);
                }
                if (packageInfo == null || !packageInfo.isExamplesPackage() || !map.containsKey(r.getId())) {
                    map.put(r.getId(), new ResourceProxy(r));
                }
            }
            String url = r.getUrl();
            if (!this.allowLoadingDuplicates && this.hasResourceVersion(r.getType(), url, r.getVersion()) && !packageInfo.isHTO()) {
                if (Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhir/SearchParameter/example"})) {
                    return;
                }
                CanonicalResource ex = (CanonicalResource)this.fetchResourceWithException(r.getType(), url);
                throw new DefinitionException(this.formatMessage("Duplicate_Resource_", new Object[]{url, r.getVersion(), ex.getVersion(), ex.fhirType()}));
            }
            switch (r.getType()) {
                case "StructureDefinition": {
                    if ("1.4.0".equals(this.version)) {
                        StructureDefinition sd = (StructureDefinition)r.getResource();
                        this.fixOldSD(sd);
                    }
                    this.structures.register(r, packageInfo);
                    break;
                }
                case "ValueSet": {
                    this.valueSets.register(r, packageInfo);
                    break;
                }
                case "CodeSystem": {
                    this.codeSystems.register(r, packageInfo);
                    break;
                }
                case "ImplementationGuide": {
                    this.guides.register(r, packageInfo);
                    break;
                }
                case "CapabilityStatement": {
                    this.capstmts.register(r, packageInfo);
                    break;
                }
                case "Measure": {
                    this.measures.register(r, packageInfo);
                    break;
                }
                case "Library": {
                    this.libraries.register(r, packageInfo);
                    break;
                }
                case "SearchParameter": {
                    this.searchParameters.register(r, packageInfo);
                    break;
                }
                case "PlanDefinition": {
                    this.plans.register(r, packageInfo);
                    break;
                }
                case "OperationDefinition": {
                    this.operations.register(r, packageInfo);
                    break;
                }
                case "Questionnaire": {
                    this.questionnaires.register(r, packageInfo);
                    break;
                }
                case "ConceptMap": {
                    this.maps.register(r, packageInfo);
                    break;
                }
                case "StructureMap": {
                    this.transforms.register(r, packageInfo);
                    break;
                }
                case "NamingSystem": {
                    this.systems.register(r, packageInfo);
                    break;
                }
                case "Requirements": {
                    this.requirements.register(r, packageInfo);
                    break;
                }
                case "ActorDefinition": {
                    this.actors.register(r, packageInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheResourceFromPackage(Resource r, PackageInformation packageInfo) throws FHIRException {
        Object object = this.lock;
        synchronized (object) {
            if (packageInfo != null) {
                this.packages.put(packageInfo.getVID(), packageInfo);
            }
            if (r.getId() != null) {
                Map<String, ResourceProxy> map = this.allResourcesById.get(r.fhirType());
                if (map == null) {
                    map = new HashMap<String, ResourceProxy>();
                    this.allResourcesById.put(r.fhirType(), map);
                }
                if (packageInfo == null || !packageInfo.isExamplesPackage() || !map.containsKey(r.getId())) {
                    map.put(r.getId(), new ResourceProxy(r));
                } else {
                    this.logger.logDebugMessage(IWorkerContext.ILoggingService.LogCategory.PROGRESS, "Ignore " + r.fhirType() + "/" + r.getId() + " from package " + packageInfo.toString());
                }
            }
            if (r instanceof CodeSystem || r instanceof NamingSystem) {
                this.oidCache.clear();
            }
            if (r instanceof CanonicalResource) {
                CanonicalResource m = (CanonicalResource)r;
                String url = m.getUrl();
                if (!this.allowLoadingDuplicates && this.hasResource(r.getClass(), url)) {
                    if (Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhir/SearchParameter/example"})) {
                        return;
                    }
                    CanonicalResource ex = (CanonicalResource)this.fetchResourceWithException(r.getClass(), url);
                    throw new DefinitionException(this.formatMessage("Duplicate_Resource_", new Object[]{url, ((CanonicalResource)r).getVersion(), ex.getVersion(), ex.fhirType()}));
                }
                if (r instanceof StructureDefinition) {
                    StructureDefinition sd = (StructureDefinition)m;
                    if ("1.4.0".equals(this.version)) {
                        this.fixOldSD(sd);
                    }
                    this.structures.see((CanonicalResource)sd, packageInfo);
                } else if (r instanceof ValueSet) {
                    this.valueSets.see((CanonicalResource)((ValueSet)m), packageInfo);
                } else if (r instanceof CodeSystem) {
                    CodeSystemUtilities.crossLinkCodeSystem((CodeSystem)((CodeSystem)r));
                    this.codeSystems.see((CanonicalResource)((CodeSystem)m), packageInfo);
                } else if (r instanceof ImplementationGuide) {
                    this.guides.see((CanonicalResource)((ImplementationGuide)m), packageInfo);
                } else if (r instanceof CapabilityStatement) {
                    this.capstmts.see((CanonicalResource)((CapabilityStatement)m), packageInfo);
                } else if (r instanceof Measure) {
                    this.measures.see((CanonicalResource)((Measure)m), packageInfo);
                } else if (r instanceof Library) {
                    this.libraries.see((CanonicalResource)((Library)m), packageInfo);
                } else if (r instanceof SearchParameter) {
                    this.searchParameters.see((CanonicalResource)((SearchParameter)m), packageInfo);
                } else if (r instanceof PlanDefinition) {
                    this.plans.see((CanonicalResource)((PlanDefinition)m), packageInfo);
                } else if (r instanceof OperationDefinition) {
                    this.operations.see((CanonicalResource)((OperationDefinition)m), packageInfo);
                } else if (r instanceof Questionnaire) {
                    this.questionnaires.see((CanonicalResource)((Questionnaire)m), packageInfo);
                } else if (r instanceof ConceptMap) {
                    this.maps.see((CanonicalResource)((ConceptMap)m), packageInfo);
                } else if (r instanceof StructureMap) {
                    this.transforms.see((CanonicalResource)((StructureMap)m), packageInfo);
                } else if (r instanceof NamingSystem) {
                    this.systems.see((CanonicalResource)((NamingSystem)m), packageInfo);
                    this.systemUrlMap = null;
                } else if (r instanceof Requirements) {
                    this.requirements.see((CanonicalResource)((Requirements)m), packageInfo);
                } else if (r instanceof ActorDefinition) {
                    this.actors.see((CanonicalResource)((ActorDefinition)m), packageInfo);
                    this.systemUrlMap = null;
                }
            }
        }
    }

    public Map<String, NamingSystem> getNSUrlMap() {
        if (this.systemUrlMap == null) {
            this.systemUrlMap = new HashMap<String, NamingSystem>();
            List nsl = this.systems.getList();
            for (NamingSystem ns : nsl) {
                for (NamingSystem.NamingSystemUniqueIdComponent uid : ns.getUniqueId()) {
                    if (uid.getType() != NamingSystem.NamingSystemIdentifierType.URI || !uid.hasValue()) continue;
                    this.systemUrlMap.put(uid.getValue(), ns);
                }
            }
        }
        return this.systemUrlMap;
    }

    public void fixOldSD(StructureDefinition sd) {
        if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT && sd.getType().equals("Extension") && sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/")) {
            sd.setSnapshot(null);
        }
        for (ElementDefinition ed : sd.getDifferential().getElement()) {
            if (ed.getPath().equals("Extension.url") || ed.getPath().endsWith(".extension.url")) {
                ed.setMin(1);
                if (ed.hasBase()) {
                    ed.getBase().setMin(1);
                }
            }
            if (!"extension".equals(ed.getSliceName())) continue;
            ed.setSliceName(null);
        }
    }

    private boolean laterVersion(String newVersion, String oldVersion) {
        newVersion = newVersion.trim();
        oldVersion = oldVersion.trim();
        if (StringUtils.isNumeric((CharSequence)newVersion) && StringUtils.isNumeric((CharSequence)oldVersion)) {
            return Double.parseDouble(newVersion) > Double.parseDouble(oldVersion);
        }
        if (this.hasDelimiter(newVersion, oldVersion, ".")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\.");
        }
        if (this.hasDelimiter(newVersion, oldVersion, "-")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\-");
        }
        if (this.hasDelimiter(newVersion, oldVersion, "_")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\_");
        }
        if (this.hasDelimiter(newVersion, oldVersion, ":")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\:");
        }
        if (this.hasDelimiter(newVersion, oldVersion, " ")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\ ");
        }
        return newVersion.compareTo(oldVersion) > 0;
    }

    private boolean hasDelimiter(String s1, String s2, String delimiter) {
        return s1.contains(delimiter) && s2.contains(delimiter) && s1.split(delimiter).length == s2.split(delimiter).length;
    }

    private boolean laterDelimitedVersion(String newVersion, String oldVersion, String delimiter) {
        String[] newParts = newVersion.split(delimiter);
        String[] oldParts = oldVersion.split(delimiter);
        for (int i = 0; i < newParts.length; ++i) {
            if (newParts[i].equals(oldParts[i])) continue;
            return this.laterVersion(newParts[i], oldParts[i]);
        }
        throw new Error(this.formatMessage("Delimited_versions_have_exact_match_for_delimiter____vs_", new Object[]{delimiter, newParts, oldParts}));
    }

    protected <T extends CanonicalResource> void seeMetadataResource(T r, Map<String, T> map, List<T> list, boolean addId) throws FHIRException {
        list.add(r);
        if (r.hasUrl()) {
            if (r.hasVersion()) {
                map.put(r.getUrl() + "|" + r.getVersion(), r);
            }
            if (!map.containsKey(r.getUrl())) {
                map.put(r.getUrl(), r);
            } else {
                ArrayList<CanonicalResource> rl = new ArrayList<CanonicalResource>();
                for (CanonicalResource t : list) {
                    if (!t.getUrl().equals(r.getUrl()) || rl.contains(t)) continue;
                    rl.add(t);
                }
                Collections.sort(rl, new MetadataResourceVersionComparator<T>(list));
                map.put(r.getUrl(), (CanonicalResource)rl.get(rl.size() - 1));
                CanonicalResource latest = null;
                for (CanonicalResource t : rl) {
                    if (!VersionUtilities.versionsCompatible((String)t.getVersion(), (String)r.getVersion())) continue;
                    latest = t;
                }
                if (latest != null) {
                    map.put(r.getUrl() + "|" + VersionUtilities.getMajMin((String)latest.getVersion()), (CanonicalResource)rl.get(rl.size() - 1));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeSystem fetchCodeSystem(String system) {
        CodeSystem cs;
        if (system == null) {
            return null;
        }
        if (system.contains("|")) {
            String s = system.substring(0, system.indexOf("|"));
            String v = system.substring(system.indexOf("|") + 1);
            return this.fetchCodeSystem(s, v);
        }
        Object object = this.lock;
        synchronized (object) {
            cs = (CodeSystem)this.codeSystems.get(system);
        }
        if (cs == null && this.locator != null) {
            this.locator.findResource((Object)this, system);
            object = this.lock;
            synchronized (object) {
                cs = (CodeSystem)this.codeSystems.get(system);
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeSystem fetchCodeSystem(String system, String version) {
        CodeSystem cs;
        if (version == null) {
            return this.fetchCodeSystem(system);
        }
        Object object = this.lock;
        synchronized (object) {
            cs = (CodeSystem)this.codeSystems.get(system, version);
        }
        if (cs == null && this.locator != null) {
            this.locator.findResource((Object)this, system);
            object = this.lock;
            synchronized (object) {
                cs = (CodeSystem)this.codeSystems.get(system);
            }
        }
        return cs;
    }

    public CodeSystem fetchSupplementedCodeSystem(String system) {
        List supplements;
        CodeSystem cs = this.fetchCodeSystem(system);
        if (cs != null && (supplements = this.codeSystems.getSupplements((CanonicalResource)cs)).size() > 0) {
            cs = CodeSystemUtilities.mergeSupplements((CodeSystem)cs, (List)supplements);
        }
        return cs;
    }

    public CodeSystem fetchSupplementedCodeSystem(String system, String version) {
        List supplements;
        CodeSystem cs = this.fetchCodeSystem(system, version);
        if (cs != null && (supplements = this.codeSystems.getSupplements((CanonicalResource)cs)).size() > 0) {
            cs = CodeSystemUtilities.mergeSupplements((CodeSystem)cs, (List)supplements);
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSystem(String system) throws TerminologyServiceException {
        Object object = this.lock;
        synchronized (object) {
            if (this.codeSystems.has(system) && ((CodeSystem)this.codeSystems.get(system)).getContent() != Enumerations.CodeSystemContentMode.NOTPRESENT) {
                return true;
            }
            if (this.supportedCodeSystems.contains(system)) {
                return true;
            }
            if (system.startsWith("http://example.org") || system.startsWith("http://acme.com") || system.startsWith("http://hl7.org/fhir/valueset-") || system.startsWith("urn:oid:")) {
                return false;
            }
            if (this.noTerminologyServer) {
                return false;
            }
            if (this.tcc.getTxcaps() == null) {
                try {
                    this.logger.logMessage("Terminology server: Check for supported code systems for " + system);
                    TerminologyCapabilities capabilityStatement = this.txCache.hasTerminologyCapabilities() ? this.txCache.getTerminologyCapabilities() : this.tcc.getClient().getTerminologyCapabilities();
                    this.txCache.cacheTerminologyCapabilities(capabilityStatement);
                    this.setTxCaps(capabilityStatement);
                }
                catch (Exception e) {
                    if (this.canRunWithoutTerminology) {
                        this.noTerminologyServer = true;
                        this.logger.logMessage("==============!! Running without terminology server !! ==============");
                        if (this.tcc.getClient() != null) {
                            this.logger.logMessage("txServer = " + this.tcc.getClient().getId());
                            this.logger.logMessage("Error = " + e.getMessage());
                        }
                        this.logger.logMessage("=====================================================================");
                        return false;
                    }
                    e.printStackTrace();
                    throw new TerminologyServiceException((Throwable)e);
                }
                if (this.supportedCodeSystems.contains(system)) {
                    return true;
                }
            }
            return false;
        }
    }

    protected void txLog(String msg) {
        if (this.tlogging) {
            this.logger.logDebugMessage(IWorkerContext.ILoggingService.LogCategory.TX, msg);
        }
    }

    public int getExpandCodesLimit() {
        return this.expandCodesLimit;
    }

    public void setExpandCodesLimit(int expandCodesLimit) {
        this.expandCodesLimit = expandCodesLimit;
    }

    public ValueSetExpansionOutcome expandVS(Resource src, ElementDefinition.ElementDefinitionBindingComponent binding, boolean cacheOk, boolean heirarchical) throws FHIRException {
        ValueSet vs = null;
        vs = this.fetchResource(ValueSet.class, binding.getValueSet(), src);
        if (vs == null) {
            throw new FHIRException(this.formatMessage("Unable_to_resolve_value_Set_", new Object[]{binding.getValueSet()}));
        }
        return this.expandVS(vs, cacheOk, heirarchical);
    }

    public ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent inc, boolean hierarchical, boolean noInactive) throws TerminologyServiceException {
        ValueSetExpansionOutcome res;
        TerminologyCache.CacheToken cacheToken;
        block6: {
            ValueSet vs = new ValueSet();
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.setCompose(new ValueSet.ValueSetComposeComponent());
            vs.getCompose().setInactive(!noInactive);
            vs.getCompose().getInclude().add(inc);
            cacheToken = this.txCache.generateExpandToken(vs, hierarchical);
            res = this.txCache.getExpansion(cacheToken);
            if (res != null) {
                return res;
            }
            Parameters p = this.constructParameters(vs, hierarchical);
            for (ValueSet.ConceptSetComponent incl : vs.getCompose().getInclude()) {
                this.codeSystemsUsed.add(incl.getSystem());
            }
            for (ValueSet.ConceptSetComponent incl : vs.getCompose().getExclude()) {
                this.codeSystemsUsed.add(incl.getSystem());
            }
            if (this.noTerminologyServer) {
                return new ValueSetExpansionOutcome(this.formatMessage("Error_expanding_ValueSet_running_without_terminology_services", new Object[0]), TerminologyServiceErrorClass.NOSERVICE);
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("_limit", Integer.toString(this.expandCodesLimit));
            params.put("_incomplete", "true");
            this.txLog("$expand on " + this.txCache.summary(vs));
            try {
                ValueSet result = this.tcc.getClient().expandValueset(vs, p, params);
                res = new ValueSetExpansionOutcome(result).setTxLink(this.txLog.getLastId());
            }
            catch (Exception e) {
                res = new ValueSetExpansionOutcome(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), TerminologyServiceErrorClass.UNKNOWN);
                if (this.txLog == null) break block6;
                res.setTxLink(this.txLog.getLastId());
            }
        }
        this.txCache.cacheExpansion(cacheToken, res, true);
        return res;
    }

    public ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean heirarchical) {
        if (this.expParameters == null) {
            throw new Error(this.formatMessage("No_Expansion_Parameters_provided", new Object[0]));
        }
        Parameters p = this.expParameters.copy();
        return this.expandVS(vs, cacheOk, heirarchical, false, p);
    }

    public ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean heirarchical, boolean incompleteOk) {
        if (this.expParameters == null) {
            throw new Error(this.formatMessage("No_Expansion_Parameters_provided", new Object[0]));
        }
        Parameters p = this.expParameters.copy();
        return this.expandVS(vs, cacheOk, heirarchical, incompleteOk, p);
    }

    public ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean hierarchical, boolean incompleteOk, Parameters pIn) {
        ValueSetExpansionOutcome res;
        if (pIn == null) {
            throw new Error(this.formatMessage("No_Parameters_provided_to_expandVS", new Object[0]));
        }
        if (vs.getUrl().equals("http://hl7.org/fhir/ValueSet/all-time-units") || vs.getUrl().equals("http://hl7.org/fhir/ValueSet/all-distance-units")) {
            return new ValueSetExpansionOutcome("This value set is not expanded correctly at this time (will be fixed in a future version)", TerminologyServiceErrorClass.VALUESET_UNSUPPORTED);
        }
        Parameters p = pIn.copy();
        if (vs.hasExpansion()) {
            return new ValueSetExpansionOutcome(vs.copy());
        }
        if (!vs.hasUrl()) {
            throw new Error(this.formatMessage("no_value_set", new Object[0]));
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            this.codeSystemsUsed.add(inc.getSystem());
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
            this.codeSystemsUsed.add(inc.getSystem());
        }
        TerminologyCache.CacheToken cacheToken = this.txCache.generateExpandToken(vs, hierarchical);
        if (cacheOk && (res = this.txCache.getExpansion(cacheToken)) != null) {
            return res;
        }
        p.setParameter("excludeNested", !hierarchical);
        if (incompleteOk) {
            p.setParameter("incomplete-ok", true);
        }
        ArrayList allErrors = new ArrayList();
        ValueSetExpander vse = this.constructValueSetExpanderSimple();
        res = null;
        try {
            res = vse.expand(vs, p);
        }
        catch (Exception e) {
            allErrors.addAll(vse.getAllErrors());
            e.printStackTrace();
            res = new ValueSetExpansionOutcome(e.getMessage(), TerminologyServiceErrorClass.UNKNOWN);
        }
        allErrors.addAll(vse.getAllErrors());
        if (res.getValueset() != null) {
            if (!res.getValueset().hasUrl()) {
                throw new Error(this.formatMessage("no_url_in_expand_value_set", new Object[0]));
            }
            this.txCache.cacheExpansion(cacheToken, res, false);
            return res;
        }
        if (res.getErrorClass() == TerminologyServiceErrorClass.INTERNAL_ERROR || this.isNoTerminologyServer()) {
            return new ValueSetExpansionOutcome(res.getError(), res.getErrorClass());
        }
        if (this.addDependentResources(p, vs)) {
            p.addParameter().setName("cache-id").setValue((DataType)new IdType(this.tcc.getCacheId()));
        }
        if (this.noTerminologyServer) {
            return new ValueSetExpansionOutcome(this.formatMessage("Error_expanding_ValueSet_running_without_terminology_services", new Object[0]), TerminologyServiceErrorClass.NOSERVICE, allErrors);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("_limit", Integer.toString(this.expandCodesLimit));
        params.put("_incomplete", "true");
        this.txLog("$expand on " + this.txCache.summary(vs));
        try {
            ValueSet result = this.tcc.getClient().expandValueset(vs, p, params);
            if (!result.hasUrl()) {
                result.setUrl(vs.getUrl());
            }
            if (!result.hasUrl()) {
                throw new Error(this.formatMessage("no_url_in_expand_value_set_2", new Object[0]));
            }
            res = new ValueSetExpansionOutcome(result).setTxLink(this.txLog.getLastId());
        }
        catch (Exception e) {
            res = new ValueSetExpansionOutcome(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), TerminologyServiceErrorClass.UNKNOWN, allErrors).setTxLink(this.txLog == null ? null : this.txLog.getLastId());
        }
        this.txCache.cacheExpansion(cacheToken, res, true);
        return res;
    }

    private boolean hasTooCostlyExpansion(ValueSet valueset) {
        return valueset != null && valueset.hasExpansion() && ToolingExtensions.hasExtension((Element)valueset.getExpansion(), (String)"http://hl7.org/fhir/StructureDefinition/valueset-toocostly");
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions options, String system, String version, String code, String display) {
        assert (options != null);
        Coding c = new Coding(system, version, code, display);
        return this.validateCode(options, c, null);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions options, String system, String version, String code, String display, ValueSet vs) {
        assert (options != null);
        Coding c = new Coding(system, version, code, display);
        return this.validateCode(options, "code", c, vs);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions options, String code, ValueSet vs) {
        assert (options != null);
        Coding c = new Coding(null, code, null);
        return this.validateCode(options.withGuessSystem(), c, vs);
    }

    /*
     * WARNING - void declaration
     */
    public void validateCodeBatch(ValidationOptions options, List<? extends IWorkerContext.CodingValidationRequest> codes, ValueSet vs) {
        if (options == null) {
            options = ValidationOptions.defaults();
        }
        for (IWorkerContext.CodingValidationRequest codingValidationRequest : codes) {
            codingValidationRequest.setCacheToken(this.txCache != null ? this.txCache.generateValidationToken(options, codingValidationRequest.getCoding(), vs, this.expParameters) : null);
            if (codingValidationRequest.getCoding().hasSystem()) {
                this.codeSystemsUsed.add(codingValidationRequest.getCoding().getSystem());
            }
            if (this.txCache == null) continue;
            codingValidationRequest.setResult(this.txCache.getValidation(codingValidationRequest.getCacheToken()));
        }
        if (options.isUseClient()) {
            for (IWorkerContext.CodingValidationRequest codingValidationRequest : codes) {
                if (codingValidationRequest.hasResult()) continue;
                try {
                    ValueSetValidator vsc = this.constructValueSetCheckerSimple(options, vs);
                    vsc.setThrowToServer(options.isUseServer() && this.tcc.getClient() != null);
                    IWorkerContext.ValidationResult validationResult = vsc.validateCode("Coding", codingValidationRequest.getCoding());
                    if (this.txCache != null) {
                        this.txCache.cacheValidation(codingValidationRequest.getCacheToken(), validationResult, false);
                    }
                    codingValidationRequest.setResult(validationResult);
                }
                catch (Exception vsc) {}
            }
        }
        for (IWorkerContext.CodingValidationRequest codingValidationRequest : codes) {
            Object codeKey;
            if (codingValidationRequest.hasResult()) continue;
            Object object = codeKey = codingValidationRequest.getCoding().hasVersion() ? codingValidationRequest.getCoding().getSystem() + "|" + codingValidationRequest.getCoding().getVersion() : codingValidationRequest.getCoding().getSystem();
            if (!options.isUseServer()) {
                codingValidationRequest.setResult(new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.formatMessage("Unable_to_validate_code_without_using_server", new Object[0]), TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS, null));
                continue;
            }
            if (this.unsupportedCodeSystems.contains(codeKey)) {
                codingValidationRequest.setResult(new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("Terminology_TX_System_NotKnown", new Object[]{codingValidationRequest.getCoding().getSystem()}), TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED, null));
                continue;
            }
            if (!this.noTerminologyServer) continue;
            codingValidationRequest.setResult(new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("Error_validating_code_running_without_terminology_services", new Object[0]), TerminologyServiceErrorClass.NOSERVICE, null));
        }
        if (this.expParameters == null) {
            throw new Error(this.formatMessage("No_ExpansionProfile_provided", new Object[0]));
        }
        Bundle batch = new Bundle();
        batch.setType(Bundle.BundleType.BATCH);
        HashSet<String> hashSet = new HashSet<String>();
        for (IWorkerContext.CodingValidationRequest codingValidationRequest : codes) {
            if (codingValidationRequest.hasResult()) continue;
            Parameters pIn = this.constructParameters(options, codingValidationRequest, vs);
            this.setTerminologyOptions(options, pIn);
            Bundle.BundleEntryComponent be = batch.addEntry();
            be.setResource((Resource)pIn);
            be.getRequest().setMethod(Bundle.HTTPVerb.POST);
            be.getRequest().setUrl("CodeSystem/$validate-code");
            be.setUserData("source", (Object)codingValidationRequest);
            hashSet.add(codingValidationRequest.getCoding().getSystem());
        }
        if (batch.getEntry().size() > 0) {
            void var7_17;
            Bundle resp;
            this.txLog("$batch validate for " + batch.getEntry().size() + " codes on systems " + ((Object)hashSet).toString());
            if (this.tcc.getClient() == null) {
                throw new FHIRException(this.formatMessage("Attempt_to_use_Terminology_server_when_no_Terminology_server_is_available", new Object[0]));
            }
            if (this.txLog != null) {
                this.txLog.clearLastId();
            }
            if ((resp = this.tcc.getClient().validateBatch(batch)) == null) {
                throw new FHIRException(this.formatMessage("TX_SERVER_NO_BATCH_RESPONSE", new Object[0]));
            }
            boolean bl = false;
            while (var7_17 < batch.getEntry().size()) {
                IWorkerContext.CodingValidationRequest t = (IWorkerContext.CodingValidationRequest)((Bundle.BundleEntryComponent)batch.getEntry().get((int)var7_17)).getUserData("source");
                Bundle.BundleEntryComponent r = (Bundle.BundleEntryComponent)resp.getEntry().get((int)var7_17);
                if (r.getResource() instanceof Parameters) {
                    t.setResult(this.processValidationResult((Parameters)r.getResource()));
                    if (this.txCache != null) {
                        this.txCache.cacheValidation(t.getCacheToken(), t.getResult(), true);
                    }
                } else {
                    t.setResult(new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.getResponseText(r.getResource()), null).setTxLink(this.txLog == null ? null : this.txLog.getLastId()));
                }
                ++var7_17;
            }
        }
    }

    private String getResponseText(Resource resource) {
        if (resource instanceof OperationOutcome) {
            return OperationOutcomeRenderer.toString((OperationOutcome)((OperationOutcome)resource));
        }
        return "Todo";
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions options, Coding code, ValueSet vs) {
        ValidationContextCarrier ctxt = new ValidationContextCarrier();
        return this.validateCode(options, "Coding", code, vs, ctxt);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions options, String path, Coding code, ValueSet vs) {
        ValidationContextCarrier ctxt = new ValidationContextCarrier();
        return this.validateCode(options, path, code, vs, ctxt);
    }

    private final String getCodeKey(Coding code) {
        return code.hasVersion() ? code.getSystem() + "|" + code.getVersion() : code.getSystem();
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions optionsArg, Coding code, ValueSet vs, ValidationContextCarrier ctxt) {
        return this.validateCode(optionsArg, "Coding", code, vs, ctxt);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions optionsArg, String path, Coding code, ValueSet vs, ValidationContextCarrier ctxt) {
        String csumm;
        ValidationOptions options;
        ValidationOptions validationOptions = options = optionsArg != null ? optionsArg : ValidationOptions.defaults();
        if (code.hasSystem()) {
            this.codeSystemsUsed.add(code.getSystem());
        }
        TerminologyCache.CacheToken cacheToken = this.cachingAllowed && this.txCache != null ? this.txCache.generateValidationToken(options, code, vs, this.expParameters) : null;
        IWorkerContext.ValidationResult res = null;
        if (this.cachingAllowed && this.txCache != null) {
            res = this.txCache.getValidation(cacheToken);
        }
        if (res != null) {
            this.updateUnsupportedCodeSystems(res, code, this.getCodeKey(code));
            return res;
        }
        ArrayList issues = new ArrayList();
        HashSet unknownSystems = new HashSet();
        String localError = null;
        String localWarning = null;
        if (options.isUseClient()) {
            try {
                ValueSetValidator vsc = this.constructValueSetCheckerSimple(options, vs, ctxt);
                vsc.setUnknownSystems(unknownSystems);
                vsc.setThrowToServer(options.isUseServer() && this.tcc.getClient() != null);
                if (!ValueSetUtilities.isServerSide((String)code.getSystem())) {
                    res = vsc.validateCode(path, code);
                    if (this.txCache != null && this.cachingAllowed) {
                        this.txCache.cacheValidation(cacheToken, res, false);
                    }
                    return res;
                }
            }
            catch (VSCheckerException e) {
                if (e.isWarning()) {
                    localWarning = e.getMessage();
                } else {
                    localError = e.getMessage();
                }
                if (e.getIssues() != null) {
                    issues.addAll(e.getIssues());
                }
            }
            catch (Exception e) {
                localError = e.getMessage();
            }
        }
        if (localError != null && this.tcc.getClient() == null) {
            if (unknownSystems.size() > 0) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, localError, TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED, issues).setUnknownSystems(unknownSystems);
            }
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, localError, TerminologyServiceErrorClass.UNKNOWN, issues);
        }
        if (localWarning != null && this.tcc.getClient() == null) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.formatMessage("Unable_to_validate_code_without_using_server", new Object[]{localWarning}), TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS, issues);
        }
        if (!options.isUseServer()) {
            if (localWarning != null) {
                return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.formatMessage("Unable_to_validate_code_without_using_server", new Object[]{localWarning}), TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS, issues);
            }
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.formatMessage("Unable_to_validate_code_without_using_server", new Object[]{localError}), TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS, issues);
        }
        String codeKey = this.getCodeKey(code);
        if (this.unsupportedCodeSystems.contains(codeKey)) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("Terminology_TX_System_NotKnown", new Object[]{code.getSystem()}), TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED, issues);
        }
        if (this.noTerminologyServer) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("Error_validating_code_running_without_terminology_services", new Object[0]), TerminologyServiceErrorClass.NOSERVICE, issues);
        }
        String string = csumm = this.cachingAllowed && this.txCache != null ? this.txCache.summary(code) : null;
        if (this.cachingAllowed && this.txCache != null) {
            this.txLog("$validate " + csumm + " for " + this.txCache.summary(vs));
        } else {
            this.txLog("$validate " + csumm + " before cache exists");
        }
        try {
            Parameters pIn = this.constructParameters(options, code);
            res = this.validateOnServer(vs, pIn, options);
        }
        catch (Exception e) {
            res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), null).setTxLink(this.txLog == null ? null : this.txLog.getLastId()).setErrorClass(TerminologyServiceErrorClass.SERVER_ERROR);
        }
        if (!res.isOk() && localError != null) {
            res.setDiagnostics("Local Error: " + localError.trim() + ". Server Error: " + res.getMessage());
        }
        this.updateUnsupportedCodeSystems(res, code, codeKey);
        if (this.cachingAllowed && this.txCache != null) {
            this.txCache.cacheValidation(cacheToken, res, true);
        }
        return res;
    }

    protected ValueSetExpander constructValueSetExpanderSimple() {
        return new ValueSetExpander((IWorkerContext)this);
    }

    protected ValueSetValidator constructValueSetCheckerSimple(ValidationOptions options, ValueSet vs, ValidationContextCarrier ctxt) {
        return new ValueSetValidator(options, vs, (IWorkerContext)this, ctxt, this.expParameters, this.tcc.getTxcaps());
    }

    protected ValueSetValidator constructValueSetCheckerSimple(ValidationOptions options, ValueSet vs) {
        return new ValueSetValidator(options, vs, (IWorkerContext)this, this.expParameters, this.tcc.getTxcaps());
    }

    protected Parameters constructParameters(ValueSet vs, boolean hierarchical) {
        Parameters p = this.expParameters.copy();
        p.setParameter("includeDefinition", false);
        p.setParameter("excludeNested", !hierarchical);
        boolean cached = this.addDependentResources(p, vs);
        if (cached) {
            p.addParameter().setName("cache-id").setValue((DataType)new IdType(this.tcc.getCacheId()));
        }
        return p;
    }

    protected Parameters constructParameters(ValidationOptions options, Coding coding) {
        Parameters pIn = new Parameters();
        pIn.addParameter().setName("coding").setValue((DataType)coding);
        if (options.isGuessSystem()) {
            pIn.addParameter().setName("implySystem").setValue((DataType)new BooleanType(true));
        }
        this.setTerminologyOptions(options, pIn);
        return pIn;
    }

    protected Parameters constructParameters(ValidationOptions options, CodeableConcept codeableConcept) {
        Parameters pIn = new Parameters();
        pIn.addParameter().setName("codeableConcept").setValue((DataType)codeableConcept);
        this.setTerminologyOptions(options, pIn);
        return pIn;
    }

    protected Parameters constructParameters(ValidationOptions options, IWorkerContext.CodingValidationRequest codingValidationRequest, ValueSet valueSet) {
        Parameters pIn = new Parameters();
        pIn.addParameter().setName("coding").setValue((DataType)codingValidationRequest.getCoding());
        if (options.isGuessSystem()) {
            pIn.addParameter().setName("implySystem").setValue((DataType)new BooleanType(true));
        }
        if (valueSet != null) {
            pIn.addParameter().setName("valueSet").setResource((Resource)valueSet);
        }
        pIn.addParameter().setName("profile").setResource((Resource)this.expParameters);
        return pIn;
    }

    private void updateUnsupportedCodeSystems(IWorkerContext.ValidationResult res, Coding code, String codeKey) {
        if (res.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED && !code.hasVersion()) {
            this.unsupportedCodeSystems.add(codeKey);
        }
    }

    private void setTerminologyOptions(ValidationOptions options, Parameters pIn) {
        for (String s : options.getLanguages()) {
            pIn.addParameter("displayLanguage", s);
        }
        if (options.getValueSetMode() != ValidationOptions.ValueSetMode.ALL_CHECKS) {
            pIn.addParameter("valueSetMode", options.getValueSetMode().toString());
        }
        if (options.isVersionFlexible()) {
            pIn.addParameter("default-to-latest-version", true);
        }
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions options, CodeableConcept code, ValueSet vs) {
        IWorkerContext.ValidationResult res;
        TerminologyCache.CacheToken cacheToken;
        block11: {
            cacheToken = this.txCache.generateValidationToken(options, code, vs, this.expParameters);
            res = null;
            if (this.cachingAllowed && (res = this.txCache.getValidation(cacheToken)) != null) {
                return res;
            }
            for (Coding c : code.getCoding()) {
                if (!c.hasSystem()) continue;
                this.codeSystemsUsed.add(c.getSystem());
            }
            HashSet unknownSystems = new HashSet();
            if (options.isUseClient()) {
                try {
                    ValueSetValidator vsc = this.constructValueSetCheckerSimple(options, vs);
                    vsc.setUnknownSystems(unknownSystems);
                    vsc.setThrowToServer(options.isUseServer() && this.tcc.getClient() != null);
                    res = vsc.validateCode("CodeableConcept", code);
                    if (this.cachingAllowed) {
                        this.txCache.cacheValidation(cacheToken, res, false);
                    }
                    return res;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!(e instanceof NoTerminologyServiceException)) break block11;
                    return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "No Terminology Service", TerminologyServiceErrorClass.NOSERVICE, null);
                }
            }
        }
        if (!options.isUseServer()) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, "Unable to validate code without using server", TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS, null);
        }
        if (this.noTerminologyServer) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Error validating code: running without terminology services", TerminologyServiceErrorClass.NOSERVICE, null);
        }
        this.txLog("$validate " + this.txCache.summary(code) + " for " + this.txCache.summary(vs));
        try {
            Parameters pIn = this.constructParameters(options, code);
            res = this.validateOnServer(vs, pIn, options);
        }
        catch (Exception e) {
            res = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), null).setTxLink(this.txLog == null ? null : this.txLog.getLastId());
        }
        if (this.cachingAllowed) {
            this.txCache.cacheValidation(cacheToken, res, true);
        }
        return res;
    }

    protected IWorkerContext.ValidationResult validateOnServer(ValueSet vs, Parameters pin, ValidationOptions options) throws FHIRException {
        if (vs != null) {
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                this.codeSystemsUsed.add(inc.getSystem());
            }
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
                this.codeSystemsUsed.add(inc.getSystem());
            }
        }
        this.addServerValidationParameters(vs, pin, options);
        if (this.txLog != null) {
            this.txLog.clearLastId();
        }
        if (this.tcc.getClient() == null) {
            throw new FHIRException(this.formatMessage("Attempt_to_use_Terminology_server_when_no_Terminology_server_is_available", new Object[0]));
        }
        Parameters pOut = vs == null ? this.tcc.getClient().validateCS(pin) : this.tcc.getClient().validateVS(pin);
        return this.processValidationResult(pOut);
    }

    protected void addServerValidationParameters(ValueSet vs, Parameters pin, ValidationOptions options) {
        boolean cache = false;
        if (vs != null) {
            if (this.tcc.isTxCaching() && this.tcc.getCacheId() != null && vs.getUrl() != null && this.tcc.getCached().contains(vs.getUrl() + "|" + vs.getVersion())) {
                pin.addParameter().setName("url").setValue((DataType)new UriType(vs.getUrl() + (String)(vs.hasVersion() ? "|" + vs.getVersion() : "")));
            } else if (options.getVsAsUrl()) {
                pin.addParameter().setName("url").setValue((DataType)new UriType(vs.getUrl()));
            } else {
                pin.addParameter().setName("valueSet").setResource((Resource)vs);
                if (vs.getUrl() != null) {
                    this.tcc.getCached().add(vs.getUrl() + "|" + vs.getVersion());
                }
            }
            cache = true;
            this.addDependentResources(pin, vs);
        }
        if (cache) {
            pin.addParameter().setName("cache-id").setValue((DataType)new IdType(this.tcc.getCacheId()));
        }
        for (Parameters.ParametersParameterComponent pp : pin.getParameter()) {
            if (!pp.getName().equals("profile")) continue;
            throw new Error(this.formatMessage("Can_only_specify_profile_in_the_context", new Object[0]));
        }
        if (this.expParameters == null) {
            throw new Error(this.formatMessage("No_ExpansionProfile_provided", new Object[0]));
        }
        pin.addParameter().setName("profile").setResource((Resource)this.expParameters);
        if (options.isDisplayWarningMode()) {
            pin.addParameter("mode", "lenient-display-validation");
        }
    }

    private boolean addDependentResources(Parameters pin, ValueSet vs) {
        boolean cache = false;
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            cache = this.addDependentResources(pin, inc, (Resource)vs) || cache;
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
            cache = this.addDependentResources(pin, inc, (Resource)vs) || cache;
        }
        return cache;
    }

    private boolean addDependentResources(Parameters pin, ValueSet.ConceptSetComponent inc, Resource src) {
        boolean cache = false;
        for (CanonicalType c : inc.getValueSet()) {
            ValueSet vs = this.fetchResource(ValueSet.class, (String)c.getValue(), src);
            if (vs == null) continue;
            pin.addParameter().setName("tx-resource").setResource((Resource)vs);
            if (this.tcc.isTxCaching() && this.tcc.getCacheId() == null || !this.tcc.getCached().contains(vs.getVUrl())) {
                this.tcc.getCached().add(vs.getVUrl());
                cache = true;
            }
            this.addDependentResources(pin, vs);
        }
        CodeSystem cs = this.fetchResource(CodeSystem.class, inc.getSystem(), src);
        if (cs != null && (cs.getContent() == Enumerations.CodeSystemContentMode.COMPLETE || cs.getContent() == Enumerations.CodeSystemContentMode.FRAGMENT)) {
            pin.addParameter().setName("tx-resource").setResource((Resource)cs);
            if (this.tcc.isTxCaching() && this.tcc.getCacheId() == null || !this.tcc.getCached().contains(cs.getVUrl())) {
                this.tcc.getCached().add(cs.getVUrl());
                cache = true;
            }
        }
        return cache;
    }

    public IWorkerContext.ValidationResult processValidationResult(Parameters pOut) {
        boolean ok = false;
        String message = "No Message returned";
        String display = null;
        String system = null;
        String code = null;
        String version = null;
        TerminologyServiceErrorClass err = TerminologyServiceErrorClass.UNKNOWN;
        for (Parameters.ParametersParameterComponent p : pOut.getParameter()) {
            if (!p.hasValue()) continue;
            if (p.getName().equals("result")) {
                ok = (Boolean)((BooleanType)p.getValue()).getValue();
                continue;
            }
            if (p.getName().equals("message")) {
                message = p.getValue().primitiveValue();
                continue;
            }
            if (p.getName().equals("display")) {
                display = p.getValue().primitiveValue();
                continue;
            }
            if (p.getName().equals("system")) {
                system = ((PrimitiveType)p.getValue()).asStringValue();
                continue;
            }
            if (p.getName().equals("version")) {
                version = ((PrimitiveType)p.getValue()).asStringValue();
                continue;
            }
            if (p.getName().equals("code")) {
                code = ((PrimitiveType)p.getValue()).asStringValue();
                continue;
            }
            if (p.getName().equals("x-caused-by-unknown-system")) {
                err = TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED;
                continue;
            }
            if (!p.getName().equals("cause")) continue;
            try {
                ValidationMessage.IssueType it = ValidationMessage.IssueType.fromCode((String)((String)((StringType)p.getValue()).getValue()));
                if (it == ValidationMessage.IssueType.UNKNOWN) {
                    err = TerminologyServiceErrorClass.UNKNOWN;
                    continue;
                }
                if (it == ValidationMessage.IssueType.NOTFOUND) {
                    err = TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED;
                    continue;
                }
                if (it == ValidationMessage.IssueType.NOTSUPPORTED) {
                    err = TerminologyServiceErrorClass.VALUESET_UNSUPPORTED;
                    continue;
                }
                err = null;
            }
            catch (FHIRException fHIRException) {}
        }
        if (!ok) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, message + " (from " + this.tcc.getClient().getId() + ")", err, null).setTxLink(this.txLog.getLastId());
        }
        if (message != null && !message.equals("No Message returned")) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, message + " (from " + this.tcc.getClient().getId() + ")", system, version, new CodeSystem.ConceptDefinitionComponent().setDisplay(display).setCode(code), display, null).setTxLink(this.txLog.getLastId());
        }
        if (display != null) {
            return new IWorkerContext.ValidationResult(system, version, new CodeSystem.ConceptDefinitionComponent().setDisplay(display).setCode(code), display).setTxLink(this.txLog.getLastId());
        }
        return new IWorkerContext.ValidationResult(system, version, new CodeSystem.ConceptDefinitionComponent().setCode(code), null).setTxLink(this.txLog.getLastId());
    }

    protected void initTS(String cachePath) throws IOException {
        if (cachePath != null && !new File(cachePath).exists()) {
            Utilities.createDirectory((String)cachePath);
        }
        this.txCache = new TerminologyCache(this.lock, cachePath);
    }

    public void clearTSCache(String url) throws Exception {
        this.txCache.removeCS(url);
    }

    public void clearTS() {
        this.txCache.clear();
    }

    public boolean isCanRunWithoutTerminology() {
        return this.canRunWithoutTerminology;
    }

    public void setCanRunWithoutTerminology(boolean canRunWithoutTerminology) {
        this.canRunWithoutTerminology = canRunWithoutTerminology;
    }

    public void setLogger(@Nonnull IWorkerContext.ILoggingService logger) {
        this.logger = logger;
    }

    public Parameters getExpansionParameters() {
        return this.expParameters;
    }

    public void setExpansionProfile(Parameters expParameters) {
        this.expParameters = expParameters;
    }

    public boolean isNoTerminologyServer() {
        return this.noTerminologyServer || this.tcc.getClient() == null;
    }

    public void setNoTerminologyServer(boolean noTerminologyServer) {
        this.noTerminologyServer = noTerminologyServer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getResourceNamesAsSet() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(this.getResourceNames());
        return res;
    }

    public boolean isAllowLoadingDuplicates() {
        return this.allowLoadingDuplicates;
    }

    public void setAllowLoadingDuplicates(boolean allowLoadingDuplicates) {
        this.allowLoadingDuplicates = allowLoadingDuplicates;
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri) throws FHIRException {
        return this.fetchResourceWithException(class_, uri, null);
    }

    public <T extends Resource> T fetchResourceWithException(String cls, String uri) throws FHIRException {
        return this.fetchResourceWithExceptionByVersion(cls, uri, null, null);
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri, Resource sourceForReference) throws FHIRException {
        return this.fetchResourceWithExceptionByVersion(class_, uri, null, sourceForReference);
    }

    public <T extends Resource> T fetchResourceWithExceptionByVersion(Class<T> class_, String uri, String version, Resource sourceForReference) throws FHIRException {
        if (uri == null) {
            return null;
        }
        ArrayList<String> pvlist = new ArrayList<String>();
        if (sourceForReference != null && sourceForReference.getSourcePackage() != null) {
            this.populatePVList(pvlist, sourceForReference.getSourcePackage());
        }
        if (class_ == StructureDefinition.class) {
            uri = ProfileUtilities.sdNs((String)uri, null);
        }
        Object object = this.lock;
        synchronized (object) {
            if (version == null) {
                if (uri.contains("|")) {
                    version = uri.substring(uri.lastIndexOf("|") + 1);
                    uri = uri.substring(0, uri.lastIndexOf("|"));
                }
            } else assert (!uri.contains("|"));
            if (uri.contains("#")) {
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (class_ == Resource.class || class_ == null) {
                if (this.structures.has(uri)) {
                    return (T)this.structures.get(uri, version, pvlist);
                }
                if (this.guides.has(uri)) {
                    return (T)this.guides.get(uri, version, pvlist);
                }
                if (this.capstmts.has(uri)) {
                    return (T)this.capstmts.get(uri, version, pvlist);
                }
                if (this.measures.has(uri)) {
                    return (T)this.measures.get(uri, version, pvlist);
                }
                if (this.libraries.has(uri)) {
                    return (T)this.libraries.get(uri, version, pvlist);
                }
                if (this.valueSets.has(uri)) {
                    return (T)this.valueSets.get(uri, version, pvlist);
                }
                if (this.codeSystems.has(uri)) {
                    return (T)this.codeSystems.get(uri, version, pvlist);
                }
                if (this.operations.has(uri)) {
                    return (T)this.operations.get(uri, version, pvlist);
                }
                if (this.searchParameters.has(uri)) {
                    return (T)this.searchParameters.get(uri, version, pvlist);
                }
                if (this.plans.has(uri)) {
                    return (T)this.plans.get(uri, version, pvlist);
                }
                if (this.maps.has(uri)) {
                    return (T)this.maps.get(uri, version, pvlist);
                }
                if (this.transforms.has(uri)) {
                    return (T)this.transforms.get(uri, version, pvlist);
                }
                if (this.actors.has(uri)) {
                    return (T)this.transforms.get(uri, version, pvlist);
                }
                if (this.requirements.has(uri)) {
                    return (T)this.transforms.get(uri, version, pvlist);
                }
                if (this.questionnaires.has(uri)) {
                    return (T)this.questionnaires.get(uri, version, pvlist);
                }
                for (Map<String, ResourceProxy> rt : this.allResourcesById.values()) {
                    for (ResourceProxy r : rt.values()) {
                        if (!uri.equals(r.getUrl()) || version != null && version != r.getResource().getMeta().getVersionId()) continue;
                        return (T)r.getResource();
                    }
                }
                if (uri.matches("((http|https):\\/\\/([A-Za-z0-9\\\\\\.\\:\\%\\$\\-]*\\/)*?)?(Account|ActivityDefinition|ActorDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|ArtifactAssessment|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BiologicallyDerivedProductDispense|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|ChargeItem|ChargeItemDefinition|Citation|Claim|ClaimResponse|ClinicalImpression|ClinicalUseDefinition|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceAssociation|DeviceDefinition|DeviceDispense|DeviceMetric|DeviceRequest|DeviceUsage|DiagnosticReport|DocumentReference|Encounter|EncounterHistory|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceReport|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|FormularyItem|GenomicStudy|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingSelection|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|InventoryItem|InventoryReport|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|NutritionProduct|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Parameters|Patient|PaymentNotice|PaymentReconciliation|Permission|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestOrchestration|Requirements|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|SubscriptionStatus|SubscriptionTopic|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestPlan|TestReport|TestScript|Transport|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?") && !uri.contains("ValueSet")) {
                    return null;
                }
                return null;
            }
            if (class_ == ImplementationGuide.class) {
                return (T)this.guides.get(uri, version, pvlist);
            }
            if (class_ == CapabilityStatement.class) {
                return (T)this.capstmts.get(uri, version, pvlist);
            }
            if (class_ == Measure.class) {
                return (T)this.measures.get(uri, version, pvlist);
            }
            if (class_ == Library.class) {
                return (T)this.libraries.get(uri, version, pvlist);
            }
            if (class_ == StructureDefinition.class) {
                return (T)this.structures.get(uri, version, pvlist);
            }
            if (class_ == StructureMap.class) {
                return (T)this.transforms.get(uri, version, pvlist);
            }
            if (class_ == ValueSet.class) {
                return (T)this.valueSets.get(uri, version, pvlist);
            }
            if (class_ == CodeSystem.class) {
                return (T)this.codeSystems.get(uri, version, pvlist);
            }
            if (class_ == ConceptMap.class) {
                return (T)this.maps.get(uri, version, pvlist);
            }
            if (class_ == ActorDefinition.class) {
                return (T)this.actors.get(uri, version, pvlist);
            }
            if (class_ == Requirements.class) {
                return (T)this.requirements.get(uri, version, pvlist);
            }
            if (class_ == PlanDefinition.class) {
                return (T)this.plans.get(uri, version, pvlist);
            }
            if (class_ == OperationDefinition.class) {
                OperationDefinition od = (OperationDefinition)this.operations.get(uri, version);
                return (T)od;
            }
            if (class_ == Questionnaire.class) {
                return (T)this.questionnaires.get(uri, version, pvlist);
            }
            if (class_ == SearchParameter.class) {
                SearchParameter res = (SearchParameter)this.searchParameters.get(uri, version, pvlist);
                return (T)res;
            }
            if (class_ == CodeSystem.class && this.codeSystems.has(uri)) {
                return (T)this.codeSystems.get(uri, version, pvlist);
            }
            if (class_ == ValueSet.class && this.valueSets.has(uri)) {
                return (T)this.valueSets.get(uri, version, pvlist);
            }
            if (class_ == Questionnaire.class) {
                return (T)this.questionnaires.get(uri, version, pvlist);
            }
            if (this.supportedCodeSystems.contains(uri)) {
                return null;
            }
            throw new FHIRException(this.formatMessage("not_done_yet_cant_fetch_", new Object[]{uri}));
        }
    }

    private void populatePVList(List<String> pvlist, PackageInformation sourcePackage) {
        pvlist.add(sourcePackage.getVID());
        ArrayList<String> toadd = new ArrayList<String>();
        do {
            toadd.clear();
            for (String s : pvlist) {
                PackageInformation pi = this.packages.get(s);
                if (pi == null) continue;
                for (String v : pi.getDependencies()) {
                    if (pvlist.contains(v) || toadd.contains(v)) continue;
                    toadd.add(v);
                }
            }
            pvlist.addAll(toadd);
        } while (toadd.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageInformation getPackageForUrl(String uri) {
        if (uri == null) {
            return null;
        }
        uri = ProfileUtilities.sdNs((String)uri, null);
        Object object = this.lock;
        synchronized (object) {
            String version = null;
            if (uri.contains("|")) {
                version = uri.substring(uri.lastIndexOf("|") + 1);
                uri = uri.substring(0, uri.lastIndexOf("|"));
            }
            if (uri.contains("#")) {
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (this.structures.has(uri)) {
                return this.structures.getPackageInfo(uri, version);
            }
            if (this.guides.has(uri)) {
                return this.guides.getPackageInfo(uri, version);
            }
            if (this.capstmts.has(uri)) {
                return this.capstmts.getPackageInfo(uri, version);
            }
            if (this.measures.has(uri)) {
                return this.measures.getPackageInfo(uri, version);
            }
            if (this.libraries.has(uri)) {
                return this.libraries.getPackageInfo(uri, version);
            }
            if (this.valueSets.has(uri)) {
                return this.valueSets.getPackageInfo(uri, version);
            }
            if (this.codeSystems.has(uri)) {
                return this.codeSystems.getPackageInfo(uri, version);
            }
            if (this.operations.has(uri)) {
                return this.operations.getPackageInfo(uri, version);
            }
            if (this.searchParameters.has(uri)) {
                return this.searchParameters.getPackageInfo(uri, version);
            }
            if (this.plans.has(uri)) {
                return this.plans.getPackageInfo(uri, version);
            }
            if (this.maps.has(uri)) {
                return this.maps.getPackageInfo(uri, version);
            }
            if (this.transforms.has(uri)) {
                return this.transforms.getPackageInfo(uri, version);
            }
            if (this.actors.has(uri)) {
                return this.actors.getPackageInfo(uri, version);
            }
            if (this.requirements.has(uri)) {
                return this.requirements.getPackageInfo(uri, version);
            }
            if (this.questionnaires.has(uri)) {
                return this.questionnaires.getPackageInfo(uri, version);
            }
            return null;
        }
    }

    public <T extends Resource> T fetchResourceWithExceptionByVersion(String cls, String uri, String version, CanonicalResource source) throws FHIRException {
        if (uri == null) {
            return null;
        }
        if ("StructureDefinition".equals(cls)) {
            uri = ProfileUtilities.sdNs((String)uri, null);
        }
        Object object = this.lock;
        synchronized (object) {
            if (version == null) {
                if (uri.contains("|")) {
                    version = uri.substring(uri.lastIndexOf("|") + 1);
                    uri = uri.substring(0, uri.lastIndexOf("|"));
                }
            } else {
                boolean b;
                boolean bl = b = !uri.contains("|");
                assert (b);
            }
            if (uri.contains("#")) {
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (cls == null || "Resource".equals(cls)) {
                if (this.structures.has(uri)) {
                    return (T)this.structures.get(uri, version);
                }
                if (this.guides.has(uri)) {
                    return (T)this.guides.get(uri, version);
                }
                if (this.capstmts.has(uri)) {
                    return (T)this.capstmts.get(uri, version);
                }
                if (this.measures.has(uri)) {
                    return (T)this.measures.get(uri, version);
                }
                if (this.libraries.has(uri)) {
                    return (T)this.libraries.get(uri, version);
                }
                if (this.valueSets.has(uri)) {
                    return (T)this.valueSets.get(uri, version);
                }
                if (this.codeSystems.has(uri)) {
                    return (T)this.codeSystems.get(uri, version);
                }
                if (this.operations.has(uri)) {
                    return (T)this.operations.get(uri, version);
                }
                if (this.searchParameters.has(uri)) {
                    return (T)this.searchParameters.get(uri, version);
                }
                if (this.plans.has(uri)) {
                    return (T)this.plans.get(uri, version);
                }
                if (this.maps.has(uri)) {
                    return (T)this.maps.get(uri, version);
                }
                if (this.transforms.has(uri)) {
                    return (T)this.transforms.get(uri, version);
                }
                if (this.actors.has(uri)) {
                    return (T)this.actors.get(uri, version);
                }
                if (this.requirements.has(uri)) {
                    return (T)this.requirements.get(uri, version);
                }
                if (this.questionnaires.has(uri)) {
                    return (T)this.questionnaires.get(uri, version);
                }
                for (Map<String, ResourceProxy> rt : this.allResourcesById.values()) {
                    for (ResourceProxy r : rt.values()) {
                        if (!uri.equals(r.getUrl())) continue;
                        return (T)r.getResource();
                    }
                }
            } else {
                if ("ImplementationGuide".equals(cls)) {
                    return (T)this.guides.get(uri, version);
                }
                if ("CapabilityStatement".equals(cls)) {
                    return (T)this.capstmts.get(uri, version);
                }
                if ("Measure".equals(cls)) {
                    return (T)this.measures.get(uri, version);
                }
                if ("Library".equals(cls)) {
                    return (T)this.libraries.get(uri, version);
                }
                if ("StructureDefinition".equals(cls)) {
                    return (T)this.structures.get(uri, version);
                }
                if ("StructureMap".equals(cls)) {
                    return (T)this.transforms.get(uri, version);
                }
                if ("Requirements".equals(cls)) {
                    return (T)this.requirements.get(uri, version);
                }
                if ("ActorDefinition".equals(cls)) {
                    return (T)this.actors.get(uri, version);
                }
                if ("ValueSet".equals(cls)) {
                    return (T)this.valueSets.get(uri, version);
                }
                if ("CodeSystem".equals(cls)) {
                    return (T)this.codeSystems.get(uri, version);
                }
                if ("ConceptMap".equals(cls)) {
                    return (T)this.maps.get(uri, version);
                }
                if ("PlanDefinition".equals(cls)) {
                    return (T)this.plans.get(uri, version);
                }
                if ("OperationDefinition".equals(cls)) {
                    OperationDefinition od = (OperationDefinition)this.operations.get(uri, version);
                    return (T)od;
                }
                if ("Questionnaire.class".equals(cls)) {
                    return (T)this.questionnaires.get(uri, version);
                }
                if ("SearchParameter.class".equals(cls)) {
                    SearchParameter res = (SearchParameter)this.searchParameters.get(uri, version);
                    return (T)res;
                }
            }
            if ("CodeSystem".equals(cls) && this.codeSystems.has(uri)) {
                return (T)this.codeSystems.get(uri, version);
            }
            if ("ValueSet".equals(cls) && this.valueSets.has(uri)) {
                return (T)this.valueSets.get(uri, version);
            }
            if ("Questionnaire".equals(cls)) {
                return (T)this.questionnaires.get(uri, version);
            }
            if (cls == null) {
                T res;
                if (uri.matches("((http|https):\\/\\/([A-Za-z0-9\\\\\\.\\:\\%\\$\\-]*\\/)*?)?(Account|ActivityDefinition|ActorDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|ArtifactAssessment|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BiologicallyDerivedProductDispense|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|ChargeItem|ChargeItemDefinition|Citation|Claim|ClaimResponse|ClinicalImpression|ClinicalUseDefinition|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceAssociation|DeviceDefinition|DeviceDispense|DeviceMetric|DeviceRequest|DeviceUsage|DiagnosticReport|DocumentReference|Encounter|EncounterHistory|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceReport|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|FormularyItem|GenomicStudy|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingSelection|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|InventoryItem|InventoryReport|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|NutritionProduct|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Parameters|Patient|PaymentNotice|PaymentReconciliation|Permission|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestOrchestration|Requirements|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|SubscriptionStatus|SubscriptionTopic|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestPlan|TestReport|TestScript|Transport|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?") && !uri.contains("ValueSet")) {
                    return null;
                }
                if ((Utilities.isAbsoluteUrl((String)uri) || uri.startsWith("ValueSet/")) && (res = null) != null) {
                    return res;
                }
                return null;
            }
            if (this.supportedCodeSystems.contains(uri)) {
                return null;
            }
            throw new FHIRException(this.formatMessage("not_done_yet_cant_fetch_", new Object[]{uri}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Resource> List<T> fetchResourcesByType(Class<T> class_) {
        ArrayList res = new ArrayList();
        Object object = this.lock;
        synchronized (object) {
            if (class_ == Resource.class || class_ == DomainResource.class || class_ == CanonicalResource.class || class_ == null) {
                res.addAll(this.structures.getList());
                res.addAll(this.guides.getList());
                res.addAll(this.capstmts.getList());
                res.addAll(this.measures.getList());
                res.addAll(this.libraries.getList());
                res.addAll(this.valueSets.getList());
                res.addAll(this.codeSystems.getList());
                res.addAll(this.operations.getList());
                res.addAll(this.searchParameters.getList());
                res.addAll(this.plans.getList());
                res.addAll(this.maps.getList());
                res.addAll(this.transforms.getList());
                res.addAll(this.questionnaires.getList());
                res.addAll(this.systems.getList());
                res.addAll(this.actors.getList());
                res.addAll(this.requirements.getList());
            } else if (class_ == ImplementationGuide.class) {
                res.addAll(this.guides.getList());
            } else if (class_ == CapabilityStatement.class) {
                res.addAll(this.capstmts.getList());
            } else if (class_ == Measure.class) {
                res.addAll(this.measures.getList());
            } else if (class_ == Library.class) {
                res.addAll(this.libraries.getList());
            } else if (class_ == StructureDefinition.class) {
                res.addAll(this.structures.getList());
            } else if (class_ == StructureMap.class) {
                res.addAll(this.transforms.getList());
            } else if (class_ == ValueSet.class) {
                res.addAll(this.valueSets.getList());
            } else if (class_ == CodeSystem.class) {
                res.addAll(this.codeSystems.getList());
            } else if (class_ == NamingSystem.class) {
                res.addAll(this.systems.getList());
            } else if (class_ == ActorDefinition.class) {
                res.addAll(this.actors.getList());
            } else if (class_ == Requirements.class) {
                res.addAll(this.requirements.getList());
            } else if (class_ == ConceptMap.class) {
                res.addAll(this.maps.getList());
            } else if (class_ == PlanDefinition.class) {
                res.addAll(this.plans.getList());
            } else if (class_ == OperationDefinition.class) {
                res.addAll(this.operations.getList());
            } else if (class_ == Questionnaire.class) {
                res.addAll(this.questionnaires.getList());
            } else if (class_ == SearchParameter.class) {
                res.addAll(this.searchParameters.getList());
            }
        }
        return res;
    }

    public Resource fetchResourceById(String type, String uri) {
        Object object = this.lock;
        synchronized (object) {
            String[] parts = uri.split("\\/");
            if (!Utilities.noString((String)type) && parts.length == 1) {
                if (this.allResourcesById.containsKey(type)) {
                    ResourceProxy proxy = this.allResourcesById.get(type).get(parts[0]);
                    Resource resource = proxy != null ? proxy.getResource() : null;
                    return resource;
                }
                return null;
            }
            if (parts.length >= 2) {
                if (!Utilities.noString((String)type) && !type.equals(parts[parts.length - 2])) {
                    throw new Error(this.formatMessage("Resource_type_mismatch_for___", new Object[]{type, uri}));
                }
                return this.allResourcesById.get(parts[parts.length - 2]).get(parts[parts.length - 1]).getResource();
            }
            throw new Error(this.formatMessage("Unable_to_process_request_for_resource_for___", new Object[]{type, uri}));
        }
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, Resource sourceForReference) {
        try {
            return this.fetchResourceWithException(class_, uri, sourceForReference);
        }
        catch (FHIRException e) {
            throw new Error(e);
        }
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        try {
            return this.fetchResourceWithException(class_, uri, null);
        }
        catch (FHIRException e) {
            throw new Error(e);
        }
    }

    public <T extends Resource> T fetchResource(Class<T> class_, String uri, String version) {
        try {
            return this.fetchResourceWithExceptionByVersion(class_, uri, version, null);
        }
        catch (FHIRException e) {
            throw new Error(e);
        }
    }

    public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
        try {
            return this.fetchResourceWithException(class_, uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public <T extends Resource> boolean hasResource(String cls, String uri) {
        try {
            return this.fetchResourceWithException(cls, uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public <T extends Resource> boolean hasResourceVersion(Class<T> class_, String uri, String version) {
        try {
            return this.fetchResourceWithExceptionByVersion(class_, uri, version, null) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public <T extends Resource> boolean hasResourceVersion(String cls, String uri, String version) {
        try {
            return this.fetchResourceWithExceptionByVersion(cls, uri, version, null) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public TranslationServices translator() {
        return this.translator;
    }

    public void setTranslator(TranslationServices translator) {
        this.translator = translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportStatus(JsonObject json) {
        Object object = this.lock;
        synchronized (object) {
            json.addProperty("codeystem-count", (Number)this.codeSystems.size());
            json.addProperty("valueset-count", (Number)this.valueSets.size());
            json.addProperty("conceptmap-count", (Number)this.maps.size());
            json.addProperty("transforms-count", (Number)this.transforms.size());
            json.addProperty("structures-count", (Number)this.structures.size());
            json.addProperty("guides-count", (Number)this.guides.size());
            json.addProperty("statements-count", (Number)this.capstmts.size());
            json.addProperty("measures-count", (Number)this.measures.size());
            json.addProperty("libraries-count", (Number)this.libraries.size());
        }
    }

    public void dropResource(Resource r) throws FHIRException {
        this.dropResource(r.fhirType(), r.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropResource(String fhirType, String id) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, ResourceProxy> map = this.allResourcesById.get(fhirType);
            if (map == null) {
                map = new HashMap<String, ResourceProxy>();
                this.allResourcesById.put(fhirType, map);
            }
            if (map.containsKey(id)) {
                map.remove(id);
            }
            if (fhirType.equals("StructureDefinition")) {
                this.structures.drop(id);
            } else if (fhirType.equals("ImplementationGuide")) {
                this.guides.drop(id);
            } else if (fhirType.equals("CapabilityStatement")) {
                this.capstmts.drop(id);
            } else if (fhirType.equals("Measure")) {
                this.measures.drop(id);
            } else if (fhirType.equals("Library")) {
                this.libraries.drop(id);
            } else if (fhirType.equals("ValueSet")) {
                this.valueSets.drop(id);
            } else if (fhirType.equals("CodeSystem")) {
                this.codeSystems.drop(id);
            } else if (fhirType.equals("OperationDefinition")) {
                this.operations.drop(id);
            } else if (fhirType.equals("Questionnaire")) {
                this.questionnaires.drop(id);
            } else if (fhirType.equals("ConceptMap")) {
                this.maps.drop(id);
            } else if (fhirType.equals("StructureMap")) {
                this.transforms.drop(id);
            } else if (fhirType.equals("NamingSystem")) {
                this.systems.drop(id);
                this.systemUrlMap = null;
            } else if (fhirType.equals("ActorDefinition")) {
                this.actors.drop(id);
            } else if (fhirType.equals("Requirements")) {
                this.requirements.drop(id);
            }
        }
    }

    private <T extends CanonicalResource> void dropMetadataResource(Map<String, T> map, String id) {
        CanonicalResource res = (CanonicalResource)map.get(id);
        if (res != null) {
            map.remove(id);
            if (map.containsKey(res.getUrl())) {
                map.remove(res.getUrl());
            }
            if (res.getVersion() != null && map.containsKey(res.getUrl() + "|" + res.getVersion())) {
                map.remove(res.getUrl() + "|" + res.getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listSupportedSystems() {
        Object object = this.lock;
        synchronized (object) {
            String sl = null;
            for (String s : this.supportedCodeSystems) {
                sl = sl == null ? s : sl + "\r\n" + s;
            }
            return sl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int totalCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.valueSets.size() + this.maps.size() + this.structures.size() + this.transforms.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConceptMap> listMaps() {
        ArrayList<ConceptMap> m = new ArrayList<ConceptMap>();
        Object object = this.lock;
        synchronized (object) {
            this.maps.listAll(m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StructureDefinition> listStructures() {
        ArrayList<StructureDefinition> m = new ArrayList<StructureDefinition>();
        Object object = this.lock;
        synchronized (object) {
            this.structures.listAll(m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructureDefinition getStructure(String code) {
        Object object = this.lock;
        synchronized (object) {
            return (StructureDefinition)this.structures.get(code);
        }
    }

    private String getUri(NamingSystem ns) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.URI) continue;
            return id.getValue();
        }
        return null;
    }

    private boolean hasOid(NamingSystem ns, String oid) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.OID || !id.getValue().equals(oid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheVS(JsonObject json, Map<String, IWorkerContext.ValidationResult> t) {
        Object object = this.lock;
        synchronized (object) {
            this.validationCache.put(json.get("url").getAsString(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchParameter getSearchParameter(String code) {
        Object object = this.lock;
        synchronized (object) {
            return (SearchParameter)this.searchParameters.get(code);
        }
    }

    public IWorkerContext.ILoggingService getLogger() {
        return this.logger;
    }

    public StructureDefinition fetchTypeDefinition(String typeName) {
        if (Utilities.isAbsoluteUrl((String)typeName)) {
            return this.fetchResource(StructureDefinition.class, typeName);
        }
        HashSet<StructureDefinition> types = new HashSet<StructureDefinition>();
        types.addAll(this.fetchTypeDefinitions(typeName));
        types.removeIf(sd -> sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT);
        if (types.size() == 0) {
            return null;
        }
        if (types.size() == 1) {
            return (StructureDefinition)types.iterator().next();
        }
        types.removeIf(sd -> !sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/"));
        if (types.size() != 1) {
            throw new FHIRException("Ambiguous type " + typeName + " (" + ((Object)types).toString() + ") (contact Grahame Grieve for investigation)");
        }
        return (StructureDefinition)types.iterator().next();
    }

    public List<StructureDefinition> fetchTypeDefinitions(String typeName) {
        ArrayList<StructureDefinition> res = new ArrayList<StructureDefinition>();
        this.structures.listAll(res);
        res.removeIf(sd -> !sd.hasType() || !sd.getType().equals(typeName) && !sd.getTypeTail().equals(typeName));
        return res;
    }

    public boolean isTlogging() {
        return this.tlogging;
    }

    public void setTlogging(boolean tlogging) {
        this.tlogging = tlogging;
    }

    public UcumService getUcumService() {
        return this.ucumService;
    }

    public void setUcumService(UcumService ucumService) {
        this.ucumService = ucumService;
    }

    public String getLinkForUrl(String corePath, String url) {
        if (url == null) {
            return null;
        }
        if (this.codeSystems.has(url)) {
            return ((CodeSystem)this.codeSystems.get(url)).getWebPath();
        }
        if (this.valueSets.has(url)) {
            return ((ValueSet)this.valueSets.get(url)).getWebPath();
        }
        if (this.maps.has(url)) {
            return ((ConceptMap)this.maps.get(url)).getWebPath();
        }
        if (this.transforms.has(url)) {
            return ((StructureMap)this.transforms.get(url)).getWebPath();
        }
        if (this.actors.has(url)) {
            return ((ActorDefinition)this.actors.get(url)).getWebPath();
        }
        if (this.requirements.has(url)) {
            return ((Requirements)this.requirements.get(url)).getWebPath();
        }
        if (this.structures.has(url)) {
            return ((StructureDefinition)this.structures.get(url)).getWebPath();
        }
        if (this.guides.has(url)) {
            return ((ImplementationGuide)this.guides.get(url)).getWebPath();
        }
        if (this.capstmts.has(url)) {
            return ((CapabilityStatement)this.capstmts.get(url)).getWebPath();
        }
        if (this.measures.has(url)) {
            return ((Measure)this.measures.get(url)).getWebPath();
        }
        if (this.libraries.has(url)) {
            return ((Library)this.libraries.get(url)).getWebPath();
        }
        if (this.searchParameters.has(url)) {
            return ((SearchParameter)this.searchParameters.get(url)).getWebPath();
        }
        if (this.questionnaires.has(url)) {
            return ((Questionnaire)this.questionnaires.get(url)).getWebPath();
        }
        if (this.operations.has(url)) {
            return ((OperationDefinition)this.operations.get(url)).getWebPath();
        }
        if (this.plans.has(url)) {
            return ((PlanDefinition)this.plans.get(url)).getWebPath();
        }
        if (url.equals("http://loinc.org")) {
            return corePath + "loinc.html";
        }
        if (url.equals("http://unitsofmeasure.org")) {
            return corePath + "ucum.html";
        }
        if (url.equals("http://snomed.info/sct")) {
            return corePath + "snomed.html";
        }
        return null;
    }

    public List<ImplementationGuide> allImplementationGuides() {
        ArrayList<ImplementationGuide> res = new ArrayList<ImplementationGuide>();
        this.guides.listAll(res);
        return res;
    }

    public Set<String> getBinaryKeysAsSet() {
        return this.binaries.keySet();
    }

    public boolean hasBinaryKey(String binaryKey) {
        return this.binaries.containsKey(binaryKey);
    }

    public byte[] getBinaryForKey(String binaryKey) {
        return this.binaries.get(binaryKey);
    }

    public void finishLoading(boolean genSnapshots) {
        if (!this.hasResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/Base")) {
            this.cacheResource((Resource)ProfileUtilities.makeBaseDefinition((String)this.version));
        }
        if (genSnapshots) {
            for (StructureDefinition sd : this.listStructures()) {
                try {
                    if (!sd.getSnapshot().isEmpty()) continue;
                    new ContextUtilities((IWorkerContext)this).generateSnapshot(sd);
                }
                catch (Exception e) {
                    System.out.println("Unable to generate snapshot @1 for " + this.tail(sd.getUrl()) + " from " + this.tail(sd.getBaseDefinition()) + " because " + e.getMessage());
                    if (!this.logger.isDebugLogging()) continue;
                    e.printStackTrace();
                }
            }
        }
        this.codeSystems.setVersion(this.version);
        this.valueSets.setVersion(this.version);
        this.maps.setVersion(this.version);
        this.transforms.setVersion(this.version);
        this.structures.setVersion(this.version);
        this.measures.setVersion(this.version);
        this.libraries.setVersion(this.version);
        this.guides.setVersion(this.version);
        this.capstmts.setVersion(this.version);
        this.searchParameters.setVersion(this.version);
        this.questionnaires.setVersion(this.version);
        this.operations.setVersion(this.version);
        this.plans.setVersion(this.version);
        this.systems.setVersion(this.version);
        this.actors.setVersion(this.version);
        this.requirements.setVersion(this.version);
    }

    protected String tail(String url) {
        if (Utilities.noString((String)url)) {
            return "noname";
        }
        if (url.contains("/")) {
            return url.substring(url.lastIndexOf("/") + 1);
        }
        return url;
    }

    public int getClientRetryCount() {
        return this.tcc.getClient() == null ? 0 : this.tcc.getClient().getRetryCount();
    }

    public IWorkerContext setClientRetryCount(int value) {
        if (this.tcc.getClient() != null) {
            this.tcc.getClient().setRetryCount(value);
        }
        return this;
    }

    public ITerminologyClient getTxClient() {
        return this.tcc.getClient();
    }

    public String getCacheId() {
        return this.tcc.getCacheId();
    }

    public void setCacheId(String cacheId) {
        this.tcc.setCacheId(cacheId);
    }

    public TerminologyCapabilities getTxCaps() {
        return this.tcc.getTxcaps();
    }

    public void setTxCaps(TerminologyCapabilities txCaps) {
        this.tcc.setTxcaps(txCaps);
        if (txCaps != null) {
            for (TerminologyCapabilities.TerminologyCapabilitiesExpansionParameterComponent t : this.tcc.getTxcaps().getExpansion().getParameter()) {
                if (!"cache-id".equals(t.getName())) continue;
                this.tcc.setTxCaching(true);
            }
            for (TerminologyCapabilities.TerminologyCapabilitiesCodeSystemComponent tccs : this.tcc.getTxcaps().getCodeSystem()) {
                this.supportedCodeSystems.add(tccs.getUri());
            }
        }
    }

    public TimeTracker clock() {
        return this.clock;
    }

    public int countAllCaches() {
        return this.codeSystems.size() + this.valueSets.size() + this.maps.size() + this.transforms.size() + this.structures.size() + this.measures.size() + this.libraries.size() + this.guides.size() + this.capstmts.size() + this.searchParameters.size() + this.questionnaires.size() + this.operations.size() + this.plans.size() + this.systems.size() + this.actors.size() + this.requirements.size();
    }

    public Set<String> getCodeSystemsUsed() {
        return this.codeSystemsUsed;
    }

    public IWorkerContextManager.ICanonicalResourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(IWorkerContextManager.ICanonicalResourceLocator locator) {
        this.locator = locator;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    protected void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        if (this.tcc.getClient() != null) {
            this.tcc.getClient().setUserAgent(userAgent);
        }
    }

    public IWorkerContextManager.IPackageLoadingTracker getPackageTracker() {
        return this.packageTracker;
    }

    public IWorkerContext setPackageTracker(IWorkerContextManager.IPackageLoadingTracker packageTracker) {
        this.packageTracker = packageTracker;
        return this;
    }

    public PEBuilder getProfiledElementBuilder(PEBuilder.PEElementPropertiesPolicy elementProps, boolean fixedProps) {
        return new PEBuilder((IWorkerContext)this, elementProps, fixedProps);
    }

    public boolean isForPublication() {
        return this.forPublication;
    }

    public void setForPublication(boolean value) {
        this.forPublication = value;
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public void setCachingAllowed(boolean cachingAllowed) {
        this.cachingAllowed = cachingAllowed;
    }

    public TerminologyCache getTxCache() {
        return this.txCache;
    }

    public class NullTranslator
    implements TranslationServices {
        public String translate(String context, String value, String targetLang) {
            return value;
        }

        public String translate(String context, String value) {
            return value;
        }

        public String toStr(float value) {
            return null;
        }

        public String toStr(Date value) {
            return null;
        }

        public String translateAndFormat(String contest, String lang, String value, Object ... args) {
            return String.format(value, args);
        }

        public Map<String, String> translations(String value) {
            return null;
        }

        public Set<String> listTranslations(String category) {
            return null;
        }
    }

    public class ResourceProxy {
        private Resource resource;
        private CanonicalResourceManager.CanonicalResourceProxy proxy;

        public ResourceProxy(Resource resource) {
            this.resource = resource;
        }

        public ResourceProxy(CanonicalResourceManager.CanonicalResourceProxy proxy) {
            this.proxy = proxy;
        }

        public Resource getResource() {
            return this.resource != null ? this.resource : this.proxy.getResource();
        }

        public CanonicalResourceManager.CanonicalResourceProxy getProxy() {
            return this.proxy;
        }

        public String getUrl() {
            if (this.resource == null) {
                return this.proxy.getUrl();
            }
            if (this.resource instanceof CanonicalResource) {
                return ((CanonicalResource)this.resource).getUrl();
            }
            return null;
        }
    }

    public class MetadataResourceVersionComparator<T extends CanonicalResource>
    implements Comparator<T> {
        private final List<T> list;

        public MetadataResourceVersionComparator(List<T> list) {
            this.list = list;
        }

        @Override
        public int compare(T arg1, T arg2) {
            String v1 = arg1.getVersion();
            String v2 = arg2.getVersion();
            if (v1 == null && v2 == null) {
                return Integer.compare(this.list.indexOf(arg1), this.list.indexOf(arg2));
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            String mm1 = VersionUtilities.getMajMin((String)v1);
            String mm2 = VersionUtilities.getMajMin((String)v2);
            if (mm1 == null || mm2 == null) {
                return v1.compareTo(v2);
            }
            return mm1.compareTo(mm2);
        }
    }
}

