/*
 * Decompiled with CFR 0.152.
 */
package help.lixin.security.config;

import help.lixin.security.properties.PublicKeyProperties;
import help.lixin.security.properties.PublicKeyStoreProperties;
import help.lixin.security.service.IPublicKeyService;
import help.lixin.security.service.impl.LocalStorePublicKeyService;
import help.lixin.security.service.impl.RemotePublicKeyService;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={PublicKeyProperties.class, PublicKeyStoreProperties.class})
public class ResourceServerPublicKeyConfig {
    @Autowired
    private PublicKeyProperties publicKeyProperties;
    @Autowired
    private PublicKeyStoreProperties publicKeyStoreProperties;

    @Bean
    @ConditionalOnMissingBean(name={"remotePublicKeyService"})
    public IPublicKeyService remotePublicKeyService(@Autowired(required=false) RestTemplate restTemplate) {
        RemotePublicKeyService remotePublicKeyService = new RemotePublicKeyService();
        remotePublicKeyService.setPublicKeyEndpointUrl(this.publicKeyProperties.getPublicKeyEndpointUrl());
        remotePublicKeyService.setClientId(this.publicKeyProperties.getClientId());
        remotePublicKeyService.setClientSecret(this.publicKeyProperties.getClientSecret());
        remotePublicKeyService.setRestTemplate((RestOperations)restTemplate);
        return remotePublicKeyService;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(name={"localStorePublicKeyService", "publicKeyService"})
    public IPublicKeyService localStorePublicKeyService(Environment environment, IPublicKeyService remotePublicKeyService) {
        String appName = environment.getProperty("spring.application.name");
        String publicKeyStoreDir = this.publicKeyStoreProperties.getPublicKeyStoreDir();
        if (null != appName) {
            publicKeyStoreDir = String.format("%s%s%s", publicKeyStoreDir, File.separator, appName);
            this.publicKeyStoreProperties.setPublicKeyStoreDir(publicKeyStoreDir);
        }
        LocalStorePublicKeyService localStorePublicKeyService = new LocalStorePublicKeyService(this.publicKeyStoreProperties.getPublicKeyStoreHome(), publicKeyStoreDir, this.publicKeyStoreProperties.getPublicKeyName());
        localStorePublicKeyService.setPublicKeyService(remotePublicKeyService);
        return localStorePublicKeyService;
    }
}

