/*
 * Decompiled with CFR 0.152.
 */
package help.lixin.security.service.impl;

import help.lixin.security.service.IPublicKeyService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStorePublicKeyService
implements IPublicKeyService {
    private Logger logger = LoggerFactory.getLogger(LocalStorePublicKeyService.class);
    private IPublicKeyService publicKeyService;
    private String publicKeyStoreHome;
    private String publicKeyStoreDir;
    private String publicKeyName;

    public LocalStorePublicKeyService(String publicKeyStoreHome, String publicKeyStoreDir, String publicKeyName) {
        this.publicKeyStoreHome = publicKeyStoreHome;
        this.publicKeyStoreDir = publicKeyStoreDir;
        this.publicKeyName = publicKeyName;
    }

    public void setPublicKeyService(IPublicKeyService publicKeyService) {
        this.publicKeyService = publicKeyService;
    }

    public IPublicKeyService getPublicKeyService() {
        return this.publicKeyService;
    }

    @Override
    public synchronized String getPublicKey() throws Exception {
        String publicKeyStoreFullPath = this.getPublicKeyStoreFullPath();
        File publicKeyFile = new File(publicKeyStoreFullPath);
        String publicKey = null;
        if (!publicKeyFile.exists() && null != this.getPublicKeyService()) {
            publicKey = this.getPublicKeyService().getPublicKey();
            try {
                FileUtils.forceMkdirParent((File)publicKeyFile);
                FileUtils.touch((File)publicKeyFile);
                IOUtils.write((byte[])publicKey.getBytes(StandardCharsets.UTF_8), (OutputStream)new FileOutputStream(publicKeyFile));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u5199\u5165\u516c\u94a5\u5230\u672c\u5730\u78c1\u76d8:[{}]", (Object)publicKeyStoreFullPath);
                }
            }
            catch (IOException e) {
                this.logger.warn("\u5199\u5165\u516c\u94a5\u5230\u672c\u5730\u78c1\u76d8:[{}]\u5931\u8d25,\u5931\u8d25\u539f\u56e0:[{}]", (Object)publicKeyStoreFullPath, (Object)e.getMessage());
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u4ece\u672c\u5730\u78c1\u76d8\u8bfb\u53d6\u516c\u94a5:[{}]", (Object)publicKeyStoreFullPath);
            }
            publicKey = IOUtils.toString((InputStream)new FileInputStream(publicKeyFile), (Charset)StandardCharsets.UTF_8);
        }
        return publicKey;
    }

    protected String getPublicKeyStoreFullPath() {
        return String.format("%s%s%s%s%s", this.publicKeyStoreHome, File.separator, this.publicKeyStoreDir, File.separator, this.publicKeyName);
    }
}

