/*
 * Decompiled with CFR 0.152.
 */
package help.lixin.security.service.impl;

import help.lixin.security.exception.UnauthorizedException;
import help.lixin.security.service.IPublicKeyService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class RemotePublicKeyService
implements IPublicKeyService {
    protected final Logger logger = LoggerFactory.getLogger(RemotePublicKeyService.class);
    private RestOperations restTemplate;
    private String publicKeyEndpointUrl;
    private String clientId;
    private String clientSecret;
    private Map<String, String> additionalParameters;

    public synchronized RestOperations getRestTemplate() {
        if (null == this.restTemplate) {
            SimpleClientHttpRequestFactory httpRequestFactory = new SimpleClientHttpRequestFactory();
            httpRequestFactory.setConnectTimeout(30000);
            httpRequestFactory.setReadTimeout(30000);
            this.restTemplate = new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
            ((RestTemplate)this.restTemplate).setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

                public void handleError(ClientHttpResponse response) throws IOException {
                    if (response.getRawStatusCode() != 400) {
                        super.handleError(response);
                    }
                }
            });
        }
        return this.restTemplate;
    }

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String getPublicKeyEndpointUrl() {
        return this.publicKeyEndpointUrl;
    }

    public void setPublicKeyEndpointUrl(String publicKeyEndpointUrl) {
        this.publicKeyEndpointUrl = publicKeyEndpointUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public Map<String, String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public void setAdditionalParameters(Map<String, String> additionalParameters) {
        this.additionalParameters = additionalParameters;
    }

    @Override
    public String getPublicKey() throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.put((Object)"Authorization", Collections.singletonList(this.getAuthorizationHeader(this.clientId, this.clientSecret)));
        String publicKey = this.getForPublicKey(this.publicKeyEndpointUrl, (MultiValueMap<String, String>)headers);
        return publicKey;
    }

    private String getAuthorizationHeader(String clientId, String clientSecret) {
        if (clientId == null || clientSecret == null) {
            this.logger.warn("Null Client ID or Client Secret detected. Endpoint that requires authentication will reject request with 401 error.");
        }
        String creds = String.format("%s:%s", clientId, clientSecret);
        try {
            return "Basic " + new String(Base64.encode((byte[])creds.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Could not convert String");
        }
    }

    private String getForPublicKey(String path, MultiValueMap<String, String> headers) throws UnauthorizedException {
        ResponseEntity responseEntity = this.getRestTemplate().exchange(path, HttpMethod.GET, new HttpEntity(null, headers), String.class, new Object[0]);
        if (responseEntity.getStatusCode().is4xxClientError()) {
            throw new UnauthorizedException((String)responseEntity.getBody());
        }
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return (String)responseEntity.getBody();
        }
        throw new UnauthorizedException((String)responseEntity.getBody());
    }
}

