/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.anticheat.server.api;

import host.anzo.anticheat.commons.utils.IpUtils;
import host.anzo.anticheat.config.AntiCheatClientConfig;
import host.anzo.anticheat.proxy.AntiCheatProxyLibrary;
import host.anzo.anticheat.server.api.enums.EAntiClientRegisterResult;
import host.anzo.anticheat.server.api.interfaces.rmi.IRMIAntiCheatClientAPI;
import host.anzo.anticheat.server.api.interfaces.rmi.IRMIAntiCheatServerAPI;
import host.anzo.anticheat.server.api.model.AntiCheatClientInfo;
import host.anzo.anticheat.server.api.model.AntiCheatTokenInfo;
import host.anzo.simon.ClosedListener;
import host.anzo.simon.Lookup;
import host.anzo.simon.Simon;
import host.anzo.simon.exceptions.EstablishConnectionFailed;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAntiCheatClientAPIConnection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AAntiCheatClientAPIConnection.class);
    private Lookup nameLookup;
    private IRMIAntiCheatServerAPI serverAPI;
    private transient ScheduledFuture<?> reconnectTask;
    private transient ScheduledFuture<?> updateTask;
    private final ApiDisconnectedListener disconnectedListener = new ApiDisconnectedListener();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private int rmiLocalProxyPort = -1;

    public abstract long getPlayersOnline();

    public abstract IRMIAntiCheatClientAPI getClientAPI();

    protected void initialize() {
        if (!AntiCheatClientConfig.RMI_ENABLED) {
            return;
        }
        this.rmiLocalProxyPort = IpUtils.getFreePort();
        if (this.rmiLocalProxyPort == -1) {
            throw new RuntimeException("Failed to find free port for RMI proxy");
        }
        int proxyStartResult = AntiCheatProxyLibrary.instance.StartTunnelFor("rmi.anzo.host", "127.0.0.1:" + this.rmiLocalProxyPort);
        if (proxyStartResult != 0) {
            throw new RuntimeException("RMI proxy startup failed. Code: " + proxyStartResult);
        }
        this.connectToAntiCheatServer();
    }

    private void connectToAntiCheatServer() {
        try {
            try {
                if (this.nameLookup == null) {
                    this.nameLookup = Simon.createNameLookup((String)"127.0.0.1", (int)this.rmiLocalProxyPort);
                }
                this.serverAPI = (IRMIAntiCheatServerAPI)this.nameLookup.lookup("master_server");
                this.nameLookup.addClosedListener((Object)this.serverAPI, (ClosedListener)this.disconnectedListener);
                EAntiClientRegisterResult registerResult = this.serverAPI.registerClient(this.getClientAPI(), this.getClientInfo());
                if (registerResult == EAntiClientRegisterResult.SUCCESS) {
                    log.info("Anti-cheat client registered on master API successfully.");
                } else {
                    log.warn("Anti-cheat client failed to connect to master API. Reason: {}", (Object)registerResult.toString());
                }
            }
            catch (EstablishConnectionFailed establishConnectionFailed) {
                log.warn("Master anti-cheat server isn't available. Make sure it's up and running.");
                if (this.updateTask == null) {
                    this.updateTask = this.scheduler.scheduleAtFixedRate(this::updateClientInfo, 10L, 10L, TimeUnit.SECONDS);
                }
                this.reconnectTask = null;
                if (this.serverAPI == null) {
                    this.onConnectionLost();
                }
            }
            catch (Exception e) {
                log.error("Error while connecting to Login API.", (Throwable)e);
                if (this.updateTask == null) {
                    this.updateTask = this.scheduler.scheduleAtFixedRate(this::updateClientInfo, 10L, 10L, TimeUnit.SECONDS);
                }
                this.reconnectTask = null;
                if (this.serverAPI == null) {
                    this.onConnectionLost();
                }
            }
        }
        finally {
            if (this.updateTask == null) {
                this.updateTask = this.scheduler.scheduleAtFixedRate(this::updateClientInfo, 10L, 10L, TimeUnit.SECONDS);
            }
            this.reconnectTask = null;
            if (this.serverAPI == null) {
                this.onConnectionLost();
            }
        }
    }

    public void updateClientInfo() {
        if (this.reconnectTask != null || this.serverAPI == null) {
            return;
        }
        AntiCheatClientInfo clientInfo = this.getClientInfo();
        try {
            this.serverAPI.updateClient(this.getClientAPI(), clientInfo);
        }
        catch (Exception e) {
            log.error("Error while updateClientInfo for client [{}]", (Object)clientInfo, (Object)e);
        }
    }

    @NotNull
    private AntiCheatClientInfo getClientInfo() {
        AntiCheatClientInfo clientInfo = new AntiCheatClientInfo(AntiCheatClientConfig.RMI_CLIENT_ID, AntiCheatClientConfig.EOS_ANTI_CHEAT_SERVER_NAME, IpUtils.getExternalIP(), AntiCheatClientConfig.RMI_CLIENT_PASSWORD);
        clientInfo.setPlayersOnline(this.getPlayersOnline());
        return clientInfo;
    }

    public AntiCheatTokenInfo validateToken(String token) {
        return this.getClientAPI().validateToken(token);
    }

    void onConnectionLost() {
        if (this.reconnectTask != null) {
            return;
        }
        log.info("Connection with anti-cheat master server API lost.");
        if (this.serverAPI != null) {
            this.nameLookup.release((Object)this.serverAPI);
            this.serverAPI = null;
        }
        this.reconnectTask = this.scheduler.schedule(() -> {
            log.info("Reconnecting to anti-cheat master server API...");
            this.connectToAntiCheatServer();
        }, 2L, TimeUnit.SECONDS);
    }

    private class ApiDisconnectedListener
    implements ClosedListener {
        private ApiDisconnectedListener() {
        }

        public void closed() {
            AAntiCheatClientAPIConnection.this.onConnectionLost();
        }
    }
}

