/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.anticheat.server.api.model;

import host.anzo.anticheat.server.api.enums.EAntiCheatClientState;
import host.anzo.anticheat.server.api.interfaces.rmi.IRMIAntiCheatClientAPI;
import java.io.Serializable;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class AntiCheatClientInfo
implements Serializable {
    private final int id;
    private final String name;
    private final String ip;
    private final String password;
    private EAntiCheatClientState state;
    private long playersOnline;
    private IRMIAntiCheatClientAPI connection;

    public AntiCheatClientInfo(int id, String name, String ip, String password) {
        this.id = id;
        this.name = name;
        this.ip = ip;
        this.password = password;
        this.state = EAntiCheatClientState.DISCONNECTED;
    }

    public void update(IRMIAntiCheatClientAPI connection, @NotNull AntiCheatClientInfo channelInfo) {
        this.connection = connection;
        this.state = EAntiCheatClientState.CONNECTED;
        this.playersOnline = channelInfo.getPlayersOnline();
    }

    public void reset() {
        this.state = EAntiCheatClientState.DISCONNECTED;
        this.connection = null;
        this.playersOnline = 0L;
    }

    @Generated
    public void setState(EAntiCheatClientState state) {
        this.state = state;
    }

    @Generated
    public void setPlayersOnline(long playersOnline) {
        this.playersOnline = playersOnline;
    }

    @Generated
    public void setConnection(IRMIAntiCheatClientAPI connection) {
        this.connection = connection;
    }

    @Generated
    public String toString() {
        return "AntiCheatClientInfo(id=" + this.getId() + ", name=" + this.getName() + ", ip=" + this.getIp() + ", password=" + this.getPassword() + ", state=" + String.valueOf((Object)this.getState()) + ", playersOnline=" + this.getPlayersOnline() + ", connection=" + String.valueOf(this.getConnection()) + ")";
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public EAntiCheatClientState getState() {
        return this.state;
    }

    @Generated
    public long getPlayersOnline() {
        return this.playersOnline;
    }

    @Generated
    public IRMIAntiCheatClientAPI getConnection() {
        return this.connection;
    }
}

