/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.etcd.handler;

import hu.icellmobilsoft.coffee.cdi.trace.annotation.Traceable;
import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.module.etcd.service.ConfigEtcdService;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

@Dependent
@Traceable
public class ConfigEtcdHandler {
    @Inject
    private ConfigEtcdService configEtcdService;

    public String getValue(String key) throws BaseException {
        HashSet<String> previousKeys = new HashSet<String>();
        return this.getValueWithCircleCheck(key, previousKeys);
    }

    public void putValue(String key, Object value) throws BaseException {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new BaseException("key is empty!");
        }
        this.configEtcdService.putValue(key, value);
    }

    private String getValueWithCircleCheck(String key, Set<String> previousKeys) throws BaseException {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new BaseException("key is empty!");
        }
        String value = this.configEtcdService.getValue(key);
        if (StringUtils.startsWith((CharSequence)value, (CharSequence)"{") && StringUtils.endsWith((CharSequence)value, (CharSequence)"}")) {
            String newKey = value.substring(1, value.length() - 1);
            if (previousKeys.contains(newKey)) {
                throw new BaseException("Circle found in the chain for key [" + key + "]!");
            }
            previousKeys.add(newKey);
            return this.getValueWithCircleCheck(newKey, previousKeys);
        }
        return value;
    }
}

