/*
 * Decompiled with CFR 0.152.
 */
package hu.icellmobilsoft.coffee.module.etcd.producer;

import hu.icellmobilsoft.coffee.dto.exception.BaseException;
import hu.icellmobilsoft.coffee.module.etcd.producer.DefaultEtcdConfigSource;
import hu.icellmobilsoft.coffee.module.etcd.producer.EtcdConfigSourceCache;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class CachedEtcdConfigSource
extends DefaultEtcdConfigSource {
    private static final Set<String> PROPERTY_NAME_CACHE = Collections.synchronizedSet(new HashSet());

    @Override
    public Set<String> getPropertyNames() {
        HashSet<String> propertyNames = new HashSet<String>();
        if (PROPERTY_NAME_CACHE.isEmpty()) {
            PROPERTY_NAME_CACHE.addAll(super.getPropertyNames());
        }
        propertyNames.addAll(PROPERTY_NAME_CACHE);
        return propertyNames;
    }

    @Override
    protected Optional<String> readValue(String propertyName) throws BaseException {
        return EtcdConfigSourceCache.instance().getValue(propertyName);
    }
}

